% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_score.R
\name{sensitivity_score}
\alias{sensitivity_score}
\title{Mean sensitivity for raster}
\usage{
sensitivity_score(x, max_risk = x$max_risk, min_count = x$min_count, ...)
}
\arguments{
\item{x}{\code{\link{sdc_raster}} object.}

\item{max_risk}{a risk value higher than \code{max_risk} will be sensitive.}

\item{min_count}{a count lower than \code{min_count} will be sensitive.}

\item{...}{passed on to \code{\link{is_sensitive}}}
}
\description{
\code{sensitivity_score} calculates the fraction of cells (with a value)
that are considered sensitive according to the used \code{\link{disclosure_risk}}
}
\examples{
\donttest{
consumption <- sdc_raster(dwellings[1:2], variable = dwellings$consumption, r = 500)

sensitivity_score(consumption)
# same as
print(consumption)

# change the rules! A higher norm generates more sensitive cells
sensitivity_score(consumption, min_count = 20)
}
}
\seealso{
Other sensitive: 
\code{\link{disclosure_risk}()},
\code{\link{is_sensitive_at}()},
\code{\link{is_sensitive}()},
\code{\link{plot_sensitive}()},
\code{\link{remove_sensitive}()},
\code{\link{sdc_raster}()}
}
\concept{sensitive}
