% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protect_neighborhood.R
\name{protect_neighborhood}
\alias{protect_neighborhood}
\title{protects raster by summing over the neighborhood}
\usage{
protect_neighborhood(x, radius = 10 * raster::res(x$value)[1], ...)
}
\arguments{
\item{x}{\code{sdc_raster()} object to be protected}

\item{radius}{of the neighborhood to take}

\item{...}{not used at the moment}
}
\value{
\code{sdc_raster} object
}
\description{
protects raster by summing over the neighborhood
}
\examples{
\donttest{
data(enterprises)

# create a sdc_raster from point data with raster with
# a resolution of 200m
production <- sdc_raster(enterprises, variable = "production"
                        , r = 200, min_count = 3)

print(production)

# plot the raster
zlim <- c(0, 3e4)
# show which raster cells are sensitive
plot(production, zlim=zlim)

# let's smooth to reduce the sensitivity
smoothed <- protect_smooth(production, bw = 400)
plot(smoothed)

neighborhood <- protect_neighborhood(production, radius=1000)
plot(neighborhood)

# what is the sensitivy fraction?
sensitivity_score(neighborhood)
}
}
