% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwellings.R
\docType{data}
\name{dwellings}
\alias{dwellings}
\title{Simulated dwellings data set}
\format{
a \code{data.frame} with 90603 rows and 4 columns.

\describe{
\item{x}{integer, x coordinate of dwelling (crs 28992)}
\item{y}{integer, y coordinate of dwelling (crs 28992)}
\item{consumption}{numeric, simulated continuous value}
\item{unemployed}{logical, simulated discrete value}
}
}
\source{
Basisregistratie Adressen en Gebouwen
\url{https://www.kadaster.nl/zakelijk/registraties/basisregistraties/bag/bag-producten}
}
\usage{
dwellings
}
\description{
The data are generated with residence/household locations from the Dutch open
data \href{https://www.kadaster.nl/zakelijk/registraties/basisregistraties/bag/bag-producten}{BAG register}.
The locations are realistic, but the associated data is simulated.
}
\examples{
\donttest{
# dwellings is a data.frame, the best way is to first turn it
# into a sf or sp object.

# create an sf object from our data
if (requireNamespace("sf")){
  dwellings_sf <- sf::st_as_sf(dwellings, coords=c("x", "y"), crs=28992)

  unemployed <- sdc_raster( dwellings_sf
                          , "unemployed"
                          , r=200
                          , max_risk = 0.9
                          )

  plot(unemployed)
  sensitivity_score(unemployed)

  unemployed_smoothed <- protect_smooth(unemployed, bw = 0.4e3)
  plot(unemployed_smoothed, main="Employment rate")
  plot(unemployed_smoothed, "sum", main = "Employment")
} else {
  message("Package 'sf' was not installed.")
}

dwellings_sp <- dwellings
# or change a data.frame into a sp object
sp::coordinates(dwellings_sp) <- ~ x + y
tryCatch(
  # not working on some OS versions.
  sp::proj4string(dwellings_sp) <- "+init=epsg:28992"
)
consumption <- sdc_raster(dwellings_sp, dwellings_sp$consumption, r = 500)
consumption

plot(consumption)

# but we can also create a raster directly from a data.frame
unemployed <- sdc_raster( dwellings[c("x","y")], dwellings$unemployed)
}
}
\keyword{datasets}
