% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalRecode.R
\docType{methods}
\name{globalRecode}
\alias{globalRecode}
\alias{globalRecode,ANY-method}
\alias{globalRecode,sdcMicroObj-method}
\alias{globalRecode-methods}
\title{Global Recoding}
\usage{
globalRecode(obj, ...)
}
\arguments{
\item{obj}{vector of class numeric or of class factor with integer labels
for recoding or an object of class \code{\link{sdcMicroObj-class}}}

\item{...}{see possible arguments below
\itemize{
\item{column}{which keyVar should be changed}
\item{breaks}{either a numeric vector of cut points or number giving the
number of intervals which x is to be cut into.}
\item{labels}{labels for the levels of the resulting category. By default,
labels are constructed using "(a,b]" interval notation.  If labels = FALSE,
simple integer codes are returned instead of a factor.}
\item{method}{method \dQuote{equidistant} for equal sized intervalls;
method \dQuote{logEqui} for equal sized intervalls for log-transformed data;
method \dQuote{equalAmount} for intervalls with approxiomately the same amount of observations}}}
}
\value{
the modified \code{\link{sdcMicroObj-class}} or a factor, unless labels = FALSE
which results in the mere integer level codes.
}
\description{
Global recoding
}
\details{
If a labels parameter is specified, its values are used to name the factor
levels.  If none is specified, the factor level labels are constructed.
}
\section{Methods}{
 \describe{
\item{list("signature(obj = \"ANY\")")}{}
\item{list("signature(obj = \"sdcMicroObj\")")}{}}
}
\examples{

data(free1)
head(globalRecode(free1[,"AGE"], breaks=c(1,9,19,29,39,49,59,69,100), labels=1:8))
table(globalRecode(free1[,"AGE"], breaks=c(1,9,19,29,39,49,59,69,100), labels=1:8))
table(globalRecode(free1[,"AGE"], breaks=c(1,9,19,29,39,49,59,69,100)))
table(globalRecode(free1[,"AGE"], breaks=6))
table(globalRecode(free1[,"AGE"], breaks=6, method="logEqui"))
table(globalRecode(free1[,"AGE"], breaks=6, method="equalAmount"))

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- globalRecode(sdc, column="urbrur", breaks=5)

}
\seealso{
\code{\link{cut}}
}
\keyword{manip}

