% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_legend.R
\name{add_legend}
\alias{add_legend}
\title{Add a legend to an scplot}
\usage{
add_legend(
  object,
  labels = NULL,
  section_labels = c("Lines", "Phases"),
  case = 1,
  position = "right",
  datalines = TRUE,
  statlines = TRUE,
  phases = TRUE,
  title = NULL,
  text = NULL,
  background = NULL
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{labels}{A character vector. Replaces the automatically build labels.
When a vector element is NA, the corresponding element will not be replaced
(e.g. c(NA, "Variable 2", NA, "Variable 4")).}

\item{section_labels}{A character vector of length two. The labels for the
lines section and phase section.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{position}{The position ("none", "left", "right", "bottom", "top", or
two-element numeric vector)}

\item{datalines}{If TRUE, a legend for the datalines is generated.}

\item{statlines}{If TRUE, a legend for the statlines is generated.}

\item{phases}{If TRUE, a legend for the phases is generated.}

\item{title}{A list with text style parameters for the title.}

\item{text}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}

\item{background}{A list with background styling arguments (fill, color,
size, linetype).}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with changed element
\code{legend}.
}
\description{
Add a legend to an scplot
}
