% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-ordinal.R
\name{rps_ordinal}
\alias{rps_ordinal}
\title{Ranked Probability Score for ordinal outcomes}
\usage{
rps_ordinal(observed, predicted, predicted_label)
}
\arguments{
\item{observed}{A factor of length n with N levels holding the observed
values.}

\item{predicted}{nxN matrix of predictive probabilities, n (number of rows)
being the number of observations and N (number of columns) the number of
possible outcomes.}

\item{predicted_label}{A factor of length N, denoting the outcome that the
probabilities in \code{predicted} correspond to.}
}
\value{
A numeric vector of size n with ranked probability scores
}
\description{
The Ranked Probability Score (RPS) measures the difference between the predicted
and observed cumulative distribution functions. It is a proper scoring rule that
takes the ordering of categories into account. Small values are better
(best is zero, worst is N - 1 where N is the number of categories).
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-nominal.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for nominal forecasts
}
\if{latex}{
  \figure{metrics-nominal.png}
}
}

\examples{
factor_levels <- c("one", "two", "three")
predicted_label <- factor(factor_levels, levels = factor_levels, ordered = TRUE)
observed <- factor(c("three", "three", "two"), levels = factor_levels, ordered = TRUE)
predicted <- matrix(
  c(0.8, 0.1, 0.1,
    0.1, 0.2, 0.7,
    0.4, 0.4, 0.2),
  nrow = 3,
  byrow = TRUE
)
rps_ordinal(observed, predicted, predicted_label)
}
\concept{scoring functions}
\keyword{metric}
