% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Create a heatmap of a scoring metric}
\usage{
plot_heatmap(scores, y = "model", x, metric)
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link[=score]{score()}}.}

\item{y}{The variable from the scores you want to show on the y-Axis. The
default for this is "model"}

\item{x}{The variable from the scores you want to show on the x-Axis. This
could be something like "horizon", or "location"}

\item{metric}{String, the metric that determines the value and colour shown
in the tiles of the heatmap.}
}
\value{
A ggplot object showing a heatmap of the desired metric
}
\description{
This function can be used to create a heatmap of one metric across different
groups, e.g. the interval score obtained by several forecasting models in
different locations.
}
\examples{
library(magrittr) # pipe operator
scores <- example_quantile \%>\%
  as_forecast_quantile \%>\%
  score()
scores <- summarise_scores(scores, by = c("model", "target_type"))
scores <- summarise_scores(
  scores, by = c("model", "target_type"),
  fun = signif, digits = 2
)

plot_heatmap(scores, x = "target_type", metric = "bias")
}
