% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-sample.R
\name{logs_sample}
\alias{logs_sample}
\title{Logarithmic score (sample-based version)}
\usage{
logs_sample(observed, predicted, ...)
}
\arguments{
\item{observed}{A vector with observed values of size n}

\item{predicted}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the number of Monte
Carlo samples. Alternatively, \code{predicted} can just be a vector of size n.}

\item{...}{Additional arguments passed to
\link[scoringRules:scores_sample_univ]{logs_sample()} from the scoringRules package.}
}
\value{
Vector with scores.
}
\description{
This function is a wrapper around the
\code{\link[scoringRules:scores_sample_univ]{logs_sample()}} function from the
\pkg{scoringRules} package.

The log score is the negative logarithm of the predictive density evaluated
at the observed value.

The function should be used to score continuous predictions only.
While the Log Score is in theory also applicable
to discrete forecasts, the problem lies in the implementation: The function
uses a kernel density estimation, which is not well defined with
integer-valued Monte Carlo Samples.
See the scoringRules package for more details and alternatives, e.g.
calculating scores for specific discrete probability distributions.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-sample.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for sample-based forecasts
}
\if{latex}{
  \figure{metrics-sample.png}
}
}

\examples{
observed <- rpois(30, lambda = 1:30)
predicted <- replicate(200, rpois(n = 30, lambda = 1:30))
logs_sample(observed, predicted)
}
\references{
Alexander Jordan, Fabian Krüger, Sebastian Lerch, Evaluating Probabilistic
Forecasts with scoringRules, \url{https://www.jstatsoft.org/article/view/v090i12}
}
\seealso{
Other log score functions: 
\code{\link{logs_nominal}()},
\code{\link{scoring-functions-binary}}
}
\concept{log score functions}
\keyword{metric}
