% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{compare_two_models}
\alias{compare_two_models}
\title{Compare Two Models Based on Subset of Common Forecasts}
\usage{
compare_two_models(
  scores,
  name_model1,
  name_model2,
  metric,
  one_sided = FALSE,
  test_type = c("non_parametric", "permutation"),
  n_permutations = 999
)
}
\arguments{
\item{scores}{A data.table of scores as produced by \code{\link[=score]{score()}}.}

\item{name_model1}{character, name of the first model}

\item{name_model2}{character, name of the model to compare against}

\item{metric}{A character vector of length one with the metric to do the
comparison on. The default is "auto", meaning that either "interval_score",
"crps", or "brier_score" will be selected where available.
See \code{\link[=available_metrics]{available_metrics()}} for available metrics.}

\item{one_sided}{Boolean, default is \code{FALSE}, whether two conduct a one-sided
instead of a two-sided test to determine significance in a pairwise
comparison.}

\item{test_type}{character, either "non_parametric" (the default) or
"permutation". This determines which kind of test shall be conducted to
determine p-values.}

\item{n_permutations}{numeric, the number of permutations for a
permutation test. Default is 999.}
}
\description{
This function compares two models based on the subset of forecasts for which
both models have made a prediction. It gets called
from \code{\link[=pairwise_comparison_one_group]{pairwise_comparison_one_group()}}, which handles the
comparison of multiple models on a single set of forecasts (there are no
subsets of forecasts to be distinguished). \code{\link[=pairwise_comparison_one_group]{pairwise_comparison_one_group()}}
in turn gets called from from \code{\link[=pairwise_comparison]{pairwise_comparison()}} which can handle
pairwise comparisons for a set of forecasts with multiple subsets, e.g.
pairwise comparisons for one set of forecasts, but done separately for two
different forecast targets.
}
\author{
Johannes Bracher, \email{johannes.bracher@kit.edu}

Nikos Bosse \email{nikosbosse@gmail.com}
}
\keyword{internal}
