% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pit.R
\name{pit_df_fast}
\alias{pit_df_fast}
\title{Probability Integral Transformation (data.frame Format, fast version)}
\usage{
pit_df_fast(data, n_replicates = 100, by = by)
}
\arguments{
\item{data}{a data.frame with the following columns: `true_value`,
`prediction`, `sample`}

\item{n_replicates}{the number of tests to perform,
each time re-randomising the PIT}

\item{by}{character vector with categories to iterate over}
}
\value{
the input data.frame (not including rows where prediction is `NA`),
with added columns `pit_p_val` and `pit_sd`
}
\description{
Wrapper around `pit()` for fast use in data.frames. This version
of the pit does not do allow any plotting, but can iterate over categories
in a data.frame as specified in the `by` argument.
}
\details{
see \code{\link{pit}}
}
\examples{
example <- scoringutils::continuous_example_data
result <- pit_df(example, full_output = TRUE)

}
\references{
Sebastian Funk, Anton Camacho, Adam J. Kucharski, Rachel Lowe,
Rosalind M. Eggo, W. John Edmunds (2019) Assessing the performance of
real-time epidemic forecasts: A case study of Ebola in the Western Area
region of Sierra Leone, 2014-15, <doi:10.1371/journal.pcbi.1006785>
}
