% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{quantile_example_data_wide}
\alias{quantile_example_data_wide}
\title{Quantile Example Data - Wide Format}
\format{
A data frame with 120 rows and 10 variables:
\describe{
  \item{true_value}{true observed values}
  \item{id}{unique identifier for true observed values}
  \item{model}{name of the model that generated the forecasts}
  \item{horizon}{forecast horzin (e.g. 1 day ahead forecast)}
  \item{lower_90}{prediction for the lower value of the 90\% interval range
  (corresponding to the 5\% quantile)}
  \item{lower_50}{prediction for the lower value of the 50\% interval range
  (corresponding to the 25\% quantile)}
  \item{lower_0}{prediction for the lower value of the 0\% interval range
  (corresponding to the 50\% quantile, i.e. the median. For computational
  reasons there need be a column with \code{lower_0} and \code{upper_0})}
  \item{upper_0}{prediction for the upper value of the 0% interval range
  (corresponding to the 50\% quantile, i.e. the median)}
  \item{upper_50}{prediction for the upper value of the 50\% interval range
  (corresponding to the 75\% quantile)}
  \item{upper_90}{prediction for the lower value of the 90\% interval range
  (corresponding to the 95\% quantile)}
}
}
\usage{
quantile_example_data_wide
}
\description{
A toy dataset for quantile forecasts of an outcome variable
}
\keyword{datasets}
