% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_replication.R
\name{run_mcstudy}
\alias{run_mcstudy}
\title{Run the Monte Carlo study by KLTG (2019), or a smaller version thereof}
\usage{
run_mcstudy(s = 2, a = 0.5, n = 12, nr_iterations = 50,
  zoom = FALSE, random_seed = 816)
}
\arguments{
\item{s, a, n}{parameters characterizing the process from which data are simulated (see Section 4 and Table 4 of KLTG, 2019). Defaults to the values reported in the main text of the paper.}

\item{nr_iterations}{number of Monte Carlo iterations (defaults to 50).}

\item{zoom}{set to \code{TRUE} to produce results for a fine grid of small (MCMC) sample sizes, as in Figure 2 of KLTG (2019).}

\item{random_seed}{seed used for running the simulation experiment. Defaults to 816.}
}
\value{
Object of class "mcstudy", containing the results of the analysis. This object can be passed to \code{plot} for plotting, see the documentation for \link{plot.mcstudy}.
}
\description{
Run the Monte Carlo study by KLTG (2019), or a smaller version thereof
}
\details{
The full results in Section 4 of KLTG (2019) are based on \code{s = 2}, \code{a = 0.5},
\code{n = 12} and \code{nr_iterations = 1000}. Producing these results takes about 140 minutes on an 
Intel i7 processor.
}
\references{
Krueger, F., Lerch, S., Thorarinsdottir, T.L. and T. Gneiting (2019): `Predictive inference based on Markov chain Monte Carlo output', working paper, Heidelberg Institute for Theoretical Studies, available at \url{http://arxiv.org/abs/1608.06802}.
}
\seealso{
\link{plot.mcstudy} produces a summary plot of the results generated by \link{run_mcstudy}
}
\author{
Fabian Krueger
}
\keyword{replication}
