% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_extract.R
\name{stat_extract}
\alias{stat_extract}
\title{Extract Summary Statistics from Model Fit Object}
\usage{
stat_extract(mod_fit = NULL, traj_angle = "deg")
}
\arguments{
\item{mod_fit}{(lme, trajectory.analysis) Model fit object of supported class (see function description text)}

\item{traj_angle}{(character) Either "deg" or "rad" for whether trajectory analysis angle information should be extracted in degrees or radians. Only required if model is trajectory analysis}
}
\value{
(data.frame) Dataframe of core summary statistics for the given model
}
\description{
Accepts model fit object and extracts core statistical information. This includes P value, test statistic, degrees of freedom, etc. Currently accepts the following model types: `stats::t.test`, `stats::lm`, `stats_nls`, `nlme::lme`, `lmerTest::lmer`, `ecodist::MRM`, or `RRPP::trajectory.analysis`
}
\examples{
# Create some example data
x <- c(3.5, 2.1, 7.5, 5.6, 3.3, 6.0, 5.6)
y <- c(2.3, 4.7, 7.8, 9.1, 4.5, 3.6, 5.1)

# Fit a linear model
mod <- lm(y ~ x)

# Extract the relevant information
stat_extract(mod_fit = mod)

}
