% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{schwab_cancelOrder}
\alias{schwab_cancelOrder}
\title{Cancel an Open Order}
\usage{
schwab_cancelOrder(orderId, account_number, accessTokenList = NULL)
}
\arguments{
\item{orderId}{A valid Schwab Order ID}

\item{account_number}{A Schwab account number associated with the Access Token}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
order API URL. Message confirming cancellation
}
\description{
Pass an Order ID and Account number to cancel an existing open order
}
\examples{
 \dontrun{

schwab_cancelOrder(orderId = 123456789, account_number = 987654321)

}
}
