% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{schwab_optionExpiration}
\alias{schwab_optionExpiration}
\title{Get Options Expiration Chain}
\usage{
schwab_optionExpiration(ticker, accessTokenList = NULL)
}
\arguments{
\item{ticker}{underlying ticker for the options chain}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a list of 2 data frames - underlying and options chain
}
\description{
Search an Option Chain for a specific ticker
}
\details{
Return a list containing two data frames. The first is the underlying data
for the symbol. The second item in the list is a data frame that contains the
options chain for the specified ticker.
}
\examples{
\dontrun{

# Pull all option contracts expiring over the next 6 months
# with 5 strikes above and below the at-the-money price
schwab_optionChain(ticker = 'SPY',
             strikes = 5,
             endDate = Sys.Date() + 180)

}
}
