% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_fcts.R
\name{make_post_request}
\alias{make_post_request}
\title{Make a POST request.}
\usage{
make_post_request(url, body, mime, soap_action = NULL, encoding = NULL)
}
\arguments{
\item{url}{A \code{sched::URL} object.}

\item{body}{The body of the POST request.}

\item{mime}{The MIME type of the body. Example: "text/xml",
"application/json".}

\item{soap_action}{In case of a SOAP request, the SOAP action to contact, as
a character string.}

\item{encoding}{The encoding to use. A valid integer or string as required by
RCurl.}
}
\value{
A sched::Request object.
}
\description{
Construct a sched::Request object with a valid header for a POST request.
}
\examples{
# Prepare the URL and the request body
the_url <- sched::URL$new('https://httpbin.org/anything')
the_body <- '{"some_key": "my_value"}'

# Make the request object
my_request <- sched::make_post_request(the_url, body = the_body,
                                       mime = "application/json")

}
