% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rule.R
\name{Rule}
\alias{Rule}
\title{Scheduling rule class.}
\description{
Scheduling rule class.

Scheduling rule class.
}
\details{
This class represents a scheduling rule, used to limit the number of events
during a certain lap of time.
}
\examples{
# Create a new Rule object:
rule <- sched::Rule$new(n=1,lap=0.2) # 1 event allowed each 2 seconds

# Wait to be allowed to process with first event:
rule$wait() # The first event will be allowed directly, no waiting time.
# Process your first event here
rule$wait() # The second event will be delayed 0.2 seconds. This time
            # includes the time passed between the first call to wait() and
            # this one.
# Process your second event here


## ------------------------------------------------
## Method `Rule$new`
## ------------------------------------------------

# Create a rule object with default parameters
r <- Rule$new()

# Create a rule object with 5 events allowed each second (default time)
r2 <- Rule$new(5L)

# Create a rule object with 5 events allowed each 3 seconds
r3 <- Rule$new(5L, 3)

## ------------------------------------------------
## Method `Rule$getN`
## ------------------------------------------------

r <- Rule$new()

#' Get the allowed number of events for a rule
print(r$getN())

## ------------------------------------------------
## Method `Rule$getLapTime`
## ------------------------------------------------

# Create a rule object with default parameters
r <- Rule$new()

#' Get the configured lap time for a rule
print(r$getLapTime())

## ------------------------------------------------
## Method `Rule$print`
## ------------------------------------------------

# Create a rule object with default parameters
r <- Rule$new()

# Print information about a rule object
print(r)

## ------------------------------------------------
## Method `Rule$wait`
## ------------------------------------------------

# Create a rule object that allows 3 events each 0.02 seconds
r <- Rule$new(3, 0.02)

#' Loop for generating 20 events
i <- 0 # event index
while (i < 20) {
  # Wait until next event is allowed
  wait_time <- r$wait()
  print(paste("We have waited", wait_time,
    "second(s) and are now allowed to process event number", i))
  i <- i + 1
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Rule-new}{\code{Rule$new()}}
\item \href{#method-Rule-getN}{\code{Rule$getN()}}
\item \href{#method-Rule-getLapTime}{\code{Rule$getLapTime()}}
\item \href{#method-Rule-print}{\code{Rule$print()}}
\item \href{#method-Rule-wait}{\code{Rule$wait()}}
\item \href{#method-Rule-clone}{\code{Rule$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rule-new"></a>}}
\if{latex}{\out{\hypertarget{method-Rule-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rule$new(n = 3L, lap = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of events during a time lap.}

\item{\code{lap}}{Duration of a time lap, in seconds.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a rule object with default parameters
r <- Rule$new()

# Create a rule object with 5 events allowed each second (default time)
r2 <- Rule$new(5L)

# Create a rule object with 5 events allowed each 3 seconds
r3 <- Rule$new(5L, 3)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rule-getN"></a>}}
\if{latex}{\out{\hypertarget{method-Rule-getN}{}}}
\subsection{Method \code{getN()}}{
Gets the number of events allowed during a lap time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rule$getN()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the number of events as an integer.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{r <- Rule$new()

#' Get the allowed number of events for a rule
print(r$getN())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rule-getLapTime"></a>}}
\if{latex}{\out{\hypertarget{method-Rule-getLapTime}{}}}
\subsection{Method \code{getLapTime()}}{
Gets the lap time.

The number of seconds during which N events are allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rule$getLapTime()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns Lap time as a numeric.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a rule object with default parameters
r <- Rule$new()

#' Get the configured lap time for a rule
print(r$getLapTime())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rule-print"></a>}}
\if{latex}{\out{\hypertarget{method-Rule-print}{}}}
\subsection{Method \code{print()}}{
Displays information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rule$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a rule object with default parameters
r <- Rule$new()

# Print information about a rule object
print(r)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rule-wait"></a>}}
\if{latex}{\out{\hypertarget{method-Rule-wait}{}}}
\subsection{Method \code{wait()}}{
Wait (sleep) until a new event is allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rule$wait(do_sleep = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{do_sleep}}{Debug parameter that turns off the call to Sys.sleep().
Use only for testing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The time passed to wait, in seconds.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a rule object that allows 3 events each 0.02 seconds
r <- Rule$new(3, 0.02)

#' Loop for generating 20 events
i <- 0 # event index
while (i < 20) {
  # Wait until next event is allowed
  wait_time <- r$wait()
  print(paste("We have waited", wait_time,
    "second(s) and are now allowed to process event number", i))
  i <- i + 1
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rule-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Rule-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
