# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate the "Bayesian Spatial Scan Statistic" by Neill et al. (2006).
#' 
#' Calculate the "Bayesian Spatial Scan Statistic" by Neill et al. (2006),
#' adapted to a spatio-temporal setting. The scan statistic assumes that,
#' given the relative risk, the data follows a Poisson distribution. The 
#' relative risk is in turn assigned a Gamma distribution prior, yielding a 
#' negative binomial marginal distribution for the counts.
#' @param counts An integer matrix (most recent timepoint in first row).
#' @param baselines A matrix with positive entries (most recent timepoint in 
#'    first row).
#' @param zones An integer vector (all zones concatenated; locations indexed 
#'    from 0 and up).
#' @param zone_lengths An integer vector.
#' @param outbreak_prob A scalar; the probability of an outbreak (at any time,
#'    any place).
#' @param alpha_null A scalar; the shape parameter for the gamma distribution
#'    under the null hypothesis of no anomaly.
#' @param beta_null A scalar; the scale parameter for the gamma distribution
#'    under the null hypothesis of no anomaly.
#' @param alpha_alt A scalar; the shape parameter for the gamma distribution
#'    under the alternative hypothesis of an anomaly.
#' @param beta_alt A scalar; the scale parameter for the gamma distribution
#'    under the alternative hypothesis of an anomaly.
#' @param inc_values A vector of possible values for the increase in the mean
#'    (and variance) of an anomalous count.
#' @param inc_probs A vector of the prior probabilities of each value in 
#'    \code{inc_values}.
#' @return A list with elements \code{priors} (list), \code{posteriors} (list), 
#'    and \code{marginal_data_prob} (scalar). The list \code{priors} has 
#'    elements
#'    \describe{
#'      \item{null_prior}{The prior probability of no anomaly.}
#'      \item{alt_prior}{The prior probability of an anomaly.}
#'      \item{inc_prior}{A vector (matrix with 1 row) of prior probabilities
#'                       of each value in the argument \code{m_values}.}
#'      \item{window_prior}{The prior probability of an outbreak in any of the
#'                          space-time windows.}
#'    }
#'    The list \code{posteriors} has elements
#'    \describe{
#'      \item{null_posterior}{The posterior probability of no anomaly.}
#'      \item{alt_posterior}{The posterior probability of an anomaly.}
#'      \item{inc_posterior}{A data frame with columns \code{inc_values} and
#'                           \code{inc_posterior}.}
#'      \item{window_posteriors}{A data frame with columns \code{zone}, 
#'                               \code{duration}, \code{log_posterior} and 
#'                               \code{log_bayes_factor}, each row 
#'                               corresponding to a space-time window.}
#'      \item{space_time_posteriors}{A matrix with the posterior anomaly 
#'                                   probability of each location-time 
#'                                   combination.}
#'      \item{location_posteriors}{A vector (matrix with 1 row) with the 
#'                                 posterior probability of an anomaly at each
#'                                 location.}
#'    }
#' @export
#' @keywords internal
scan_bayes_negbin_cpp <- function(counts, baselines, zones, zone_lengths, outbreak_prob, alpha_null, beta_null, alpha_alt, beta_alt, inc_values, inc_probs) {
    .Call(`_scanstatistics_scan_bayes_negbin_cpp`, counts, baselines, zones, zone_lengths, outbreak_prob, alpha_null, beta_null, alpha_alt, beta_alt, inc_values, inc_probs)
}

#' Calculate the expectation-based negative binomial scan statistic.
#'
#' Calculate the expectation-based negative binomial scan statistic and Monte
#' Carlo replicates.
#' @param counts Integer matrix (most recent timepoint in first row)
#' @param baselines Matrix (most recent timepoint in first row)
#' @param overdisp Matrix (most recent timepoint in first row)
#' @param zones Integer vector (all zones concatenated; locations indexed from
#'    0 and up)
#' @param zone_lengths Integer vector
#' @param store_everything Boolean
#' @param num_mcsim Integer
#' @param score_hotspot Boolean
#' @return A list with elements \code{observed} and \code{simulated}, each 
#'    being a data frame with columns:
#'    \describe{
#'      \item{zone}{The top-scoring zone (spatial component of MLC).}
#'      \item{duration}{The corresponding duration (time-length of MLC).}
#'      \item{score}{The value of the loglihood ratio statistic (the scan
#'                   statistic).}
#'      \item{relrisk}{The estimated relative risk.}
#'      \item{n_iter}{The number of iterations performed by the EM algorithm.}
#'    }
#' @export
#' @keywords internal
scan_eb_negbin_cpp <- function(counts, baselines, overdisp, zones, zone_lengths, store_everything, num_mcsim, score_hotspot) {
    .Call(`_scanstatistics_scan_eb_negbin_cpp`, counts, baselines, overdisp, zones, zone_lengths, store_everything, num_mcsim, score_hotspot)
}

#' Calculate the expecation-based Poisson scan statistic.
#' 
#' Calculate the expectation-based Poisson scan statistic and Monte Carlo 
#' replicates.
#' @param counts An integer matrix (most recent timepoint in first row).
#' @param baselines A matrix with positive entries (most recent timepoint in 
#'    first row).
#' @param zones An integer vector (all zones concatenated; locations indexed 
#'    from 0 and up).
#' @param zone_lengths An integer vector.
#' @param store_everything A boolean.
#' @param num_mcsim An integer.
#' @return A list with elements \code{observed} and \code{simulated}, each 
#'    being a data frame with columns:
#'    \describe{
#'      \item{zone}{The top-scoring zone (spatial component of MLC).}
#'      \item{duration}{The corresponding duration (time-length of MLC).}
#'      \item{score}{The value of the loglihood ratio statistic (the scan
#'                   statistic).}
#'      \item{relrisk_in}{The estimated relative risk inside.}
#'      \item{relrisk_in}{The estimated relative risk outside.}
#'    }
#' @export
#' @keywords internal
scan_eb_poisson_cpp <- function(counts, baselines, zones, zone_lengths, store_everything, num_mcsim) {
    .Call(`_scanstatistics_scan_eb_poisson_cpp`, counts, baselines, zones, zone_lengths, store_everything, num_mcsim)
}

#' Calculate the highest-value EB ZIP loglihood ratio statistic.
#'
#' Calculate the expectation-based ZIP loglihood ratio statistic for each zone
#' and duration, but only keep the zone and duration with the highest value
#' (the MLC). The estimate of the relative risk is also calculated, along with
#' the number of iterations the EM algorithm performed.
#' @param counts matrix (most recent timepoint in first row)
#' @param baselines matrix (most recent timepoint in first row)
#' @param probs matrix (most recent timepoint in first row)
#' @param zones integer vector (all zones concatenated; locations indexed from
#'    0 and up)
#' @param zone_lengths integer vector
#' @param rel_tol double
#' @param store_everything boolean
#' @param num_mcsim int
#' @return A list with elements \code{observed} and \code{simulated}, each 
#'    being a data frame with columns:
#'    \describe{
#'      \item{zone}{The top-scoring zone (spatial component of MLC).}
#'      \item{duration}{The corresponding duration (time-length of MLC).}
#'      \item{score}{The value of the loglihood ratio statistic (the scan
#'                   statistic).}
#'      \item{relrisk}{The estimated relative risk.}
#'      \item{n_iter}{The number of iterations performed by the EM algorithm.}
#'    }
#' @export
#' @keywords internal
scan_eb_zip_cpp <- function(counts, baselines, probs, zones, zone_lengths, rel_tol, store_everything, num_mcsim) {
    .Call(`_scanstatistics_scan_eb_zip_cpp`, counts, baselines, probs, zones, zone_lengths, rel_tol, store_everything, num_mcsim)
}

#' Calculate the space-time permutation scan statistic.
#'
#' Calculate the space-time permutation scan statistic (Kulldorff 2005) and 
#' Monte Carloo  replicates.
#' @param counts An integer matrix (most recent timepoint in first row).
#' @param baselines A matrix with positive entries (most recent timepoint in 
#'    first row).
#' @param zones An integer vector (all zones concatenated; locations indexed 
#'    from 0 and up)
#' @param zone_lengths An integer vector.
#' @param store_everything A boolean.
#' @param num_mcsim An integer.
#' @return A list with elements \code{observed} and \code{simulated}, each 
#'    being a data frame with columns:
#'    \describe{
#'      \item{zone}{The top-scoring zone (spatial component of MLC).}
#'      \item{duration}{The corresponding duration (time-length of MLC).}
#'      \item{score}{The value of the loglihood ratio statistic (the scan
#'                   statistic).}
#'      \item{relrisk_in}{The estimated relative risk inside.}
#'      \item{relrisk_in}{The estimated relative risk outside.}
#'    }
#' @export
#' @keywords internal
scan_pb_perm_cpp <- function(counts, baselines, zones, zone_lengths, store_everything, num_mcsim) {
    .Call(`_scanstatistics_scan_pb_perm_cpp`, counts, baselines, zones, zone_lengths, store_everything, num_mcsim)
}

#' Calculate the population-based Poisson scan statistic.
#'
#' Calculate the population-based Poisson scan statistic and Monte Carlo 
#' replicates.
#' @param counts integer matrix (most recent timepoint in first row)
#' @param baselines matrix (most recent timepoint in first row)
#' @param zones integer vector (all zones concatenated; locations indexed from
#'    0 and up)
#' @param zone_lengths integer vector
#' @param store_everything boolean
#' @param num_mcsim int
#' @return A list with elements \code{observed} and \code{simulated}, each 
#'    being a data frame with columns:
#'    \describe{
#'      \item{zone}{The top-scoring zone (spatial component of MLC).}
#'      \item{duration}{The corresponding duration (time-length of MLC).}
#'      \item{score}{The value of the loglihood ratio statistic (the scan
#'                   statistic).}
#'      \item{relrisk_in}{The estimated relative risk inside.}
#'      \item{relrisk_in}{The estimated relative risk outside.}
#'    }
#' @export
#' @keywords internal
scan_pb_poisson_cpp <- function(counts, baselines, zones, zone_lengths, store_everything, num_mcsim) {
    .Call(`_scanstatistics_scan_pb_poisson_cpp`, counts, baselines, zones, zone_lengths, store_everything, num_mcsim)
}

#' Get indices of zero elements in a vector.
#' @param v An integer vector.
#' @return A vector with the indices of elements equal to zero in \code{v}.
#'    Indices start at zero.
#' @keywords internal
#' @export
get_zero_indices <- function(v) {
    .Call(`_scanstatistics_get_zero_indices`, v)
}

#' Permute the entries of the matrix, preserving row and column marginals.
#' 
#' Permute the entries of the matrix, preserving row and column marginals.
#' @param A An integer matrix.
#' @return An integer matrix.
#' @keywords internal
permute_matrix <- function(A) {
    .Call(`_scanstatistics_permute_matrix`, A)
}

