% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_scdf.R
\name{random_scdf}
\alias{random_scdf}
\title{Single-case data generator}
\usage{
random_scdf(design = NULL, round = NA, random_names = FALSE, seed = NULL, ...)
}
\arguments{
\item{design}{A design matrix which is created by \code{design} and specifies
all parameters.}

\item{round}{Rounds the scores to the defined decimal. To round to the second
decimal, set \code{round = 2}.}

\item{random_names}{Is \code{FALSE} by default. If set \code{random_names =
  TRUE} cases are assigned random first names. If set \code{"neutral", "male"
  or "female"} only gender neutral, male, or female names are chosen. The
names are drawn from the 2,000 most popular names for newborns in 2012 in
the U.S. (1,000 male and 1,000 female names).}

\item{seed}{A seed number for the random generator.}

\item{...}{arguments that are directly passed to the \code{design} function
for a more concise coding.}
}
\value{
A single-case data frame. See \code{\link{scdf}} to learn about this
format.
}
\description{
The \code{random_scdf} function generates random single-case data frames for
monte-carlo studies and demonstration purposes. \code{design} is used to set
up a design matrix with all parameters needed for the \code{random_scdf}
function.
}
\examples{

## Create random single-case data and inspect it
design <- design(
  n = 3, rtt = 0.75, slope = 0.1, extreme_prop = 0.1,
  missing_prop = 0.1
)
dat <- random_scdf(design, round = 1, random_names = TRUE, seed = 123)
describe(dat)

## And now have a look at poisson-distributed data
design <- design(
  n = 3, B_start = c(6, 10, 14), mt = c(12, 20, 22), start_value = 10,
  distribution = "poisson", level = -5, missing_prop = 0.1
)
dat <- random_scdf(design, seed = 1234)
pand(dat, decreasing = TRUE, correction = FALSE)
}
\author{
Juergen Wibert
}
\concept{mc fucntions}
\keyword{datagen}
