% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour-mapping.r
\name{col_numeric}
\alias{col_numeric}
\alias{col_bin}
\alias{col_quantile}
\alias{col_factor}
\title{Colour mapping}
\usage{
col_numeric(
  palette,
  domain,
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE
)

col_bin(
  palette,
  domain,
  bins = 7,
  pretty = TRUE,
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE,
  right = FALSE
)

col_quantile(
  palette,
  domain,
  n = 4,
  probs = seq(0, 1, length.out = n + 1),
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE,
  right = FALSE
)

col_factor(
  palette,
  domain,
  levels = NULL,
  ordered = FALSE,
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE
)
}
\arguments{
\item{palette}{The colours or colour function that values will be mapped to}

\item{domain}{The possible values that can be mapped.

For \code{col_numeric} and \code{col_bin}, this can be a simple numeric
range (e.g. \code{c(0, 100)}); \code{col_quantile} needs representative
numeric data; and \code{col_factor} needs categorical data.

If \code{NULL}, then whenever the resulting colour function is called, the
\code{x} value will represent the domain. This implies that if the function
is invoked multiple times, the encoding between values and colours may not
be consistent; if consistency is needed, you must provide a non-\code{NULL}
domain.}

\item{na.color}{The colour to return for \code{NA} values. Note that
\code{na.color = NA} is valid.}

\item{alpha}{Whether alpha channels should be respected or ignored. If \code{TRUE}
then colors without explicit alpha information will be treated as fully
opaque.}

\item{reverse}{Whether the colors (or color function) in \code{palette} should be
used in reverse order. For example, if the default order of a palette goes
from blue to green, then \code{reverse = TRUE} will result in the colors going
from green to blue.}

\item{bins}{Either a numeric vector of two or more unique cut points or a
single number (greater than or equal to 2) giving the number of intervals
into which the domain values are to be cut.}

\item{pretty}{Whether to use the function \code{\link[=pretty]{pretty()}} to generate
the bins when the argument \code{bins} is a single number. When
\code{pretty = TRUE}, the actual number of bins may not be the number of
bins you specified. When \code{pretty = FALSE}, \code{\link[=seq]{seq()}} is used
to generate the bins and the breaks may not be "pretty".}

\item{right}{parameter supplied to \code{\link[base:cut]{base::cut()}}. See Details}

\item{n}{Number of equal-size quantiles desired. For more precise control,
use the \code{probs} argument instead.}

\item{probs}{See \code{\link[stats:quantile]{stats::quantile()}}. If provided, the \code{n}
argument is ignored.}

\item{levels}{An alternate way of specifying levels; if specified, domain is
ignored}

\item{ordered}{If \code{TRUE} and \code{domain} needs to be coerced to a
factor, treat it as already in the correct order}
}
\value{
A function that takes a single parameter \code{x}; when called with a
vector of numbers (except for \code{col_factor}, which expects
factors/characters), #RRGGBB colour strings are returned (unless
\code{alpha = TRUE} in which case #RRGGBBAA may also be possible).
}
\description{
Conveniently maps data values (numeric or factor/character) to colours
according to a given palette, which can be provided in a variety of formats.
}
\details{
\code{col_numeric} is a simple linear mapping from continuous numeric data
to an interpolated palette.

\code{col_bin} also maps continuous numeric data, but performs
binning based on value (see the \code{\link[base:cut]{base::cut()}} function). \code{col_bin}
defaults for the \code{cut} function are \code{include.lowest = TRUE} and
\code{right = FALSE}.

\code{col_quantile} similarly bins numeric data, but via the
\code{\link[stats:quantile]{stats::quantile()}} function.

\code{col_factor} maps factors to colours. If the palette is
discrete and has a different number of colours than the number of factors,
interpolation is used.

The \code{palette} argument can be any of the following:
\enumerate{
\item{A character vector of RGB or named colours. Examples: \code{palette()}, \code{c("#000000", "#0000FF", "#FFFFFF")}, \code{topo.colors(10)}}
\item{The name of an RColorBrewer palette, e.g. \code{"BuPu"} or \code{"Greens"}.}
\item{The full name of a viridis palette: \code{"viridis"}, \code{"magma"}, \code{"inferno"}, or \code{"plasma"}.}
\item{A function that receives a single value between 0 and 1 and returns a colour. Examples: \code{colorRamp(c("#000000", "#FFFFFF"), interpolate="spline")}.}
}
}
\examples{
pal <- col_bin("Greens", domain = 0:100)
show_col(pal(sort(runif(10, 60, 100))))

# Exponential distribution, mapped continuously
show_col(col_numeric("Blues", domain = NULL)(sort(rexp(16))))
# Exponential distribution, mapped by interval
show_col(col_bin("Blues", domain = NULL, bins = 4)(sort(rexp(16))))
# Exponential distribution, mapped by quantile
show_col(col_quantile("Blues", domain = NULL)(sort(rexp(16))))

# Categorical data; by default, the values being coloured span the gamut...
show_col(col_factor("RdYlBu", domain = NULL)(LETTERS[1:5]))
# ...unless the data is a factor, without droplevels...
show_col(col_factor("RdYlBu", domain = NULL)(factor(LETTERS[1:5], levels = LETTERS)))
# ...or the domain is stated explicitly.
show_col(col_factor("RdYlBu", levels = LETTERS)(LETTERS[1:5]))
}
