% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-dollar.R
\name{dollar_format}
\alias{dollar_format}
\alias{dollar}
\title{Superseded interface to \code{label_dollar()}}
\usage{
dollar_format(
  accuracy = NULL,
  scale = 1,
  prefix = "$",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  largest_with_cents = 1e+05,
  negative_parens = deprecated(),
  ...
)

dollar(
  x,
  accuracy = NULL,
  scale = 1,
  prefix = "$",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  largest_with_cents = 1e+05,
  negative_parens = deprecated(),
  style_negative = c("hyphen", "minus", "parens"),
  scale_cut = NULL,
  ...
)
}
\arguments{
\item{accuracy}{Number to round to. If \code{NULL}, the default,
values will be rounded to the nearest integer, unless any of the
values has non-zero fractional component (e.g. cents) and the largest
value is less than \code{largest_with_cents} which by default is 100,000.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{prefix}{Symbols to display before and after value.}

\item{suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{largest_with_cents}{Number to round to. If \code{NULL}, the default,
values will be rounded to the nearest integer, unless any of the
values has non-zero fractional component (e.g. cents) and the largest
value is less than \code{largest_with_cents} which by default is 100,000.}

\item{negative_parens}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{style_negative = "parens"} instead.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{x}{A numeric vector}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions are kept for backward compatibility; you should switch
to \code{\link[=label_dollar]{label_dollar()}} for new code.
}
\keyword{internal}
