% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatter.r
\name{number_bytes_format}
\alias{number_bytes_format}
\alias{number_bytes}
\title{Bytes formatter: convert to byte measurement and display symbol.}
\usage{
number_bytes_format(symbol = "auto", units = "binary", ...)

number_bytes(x, symbol = "auto", units = c("binary", "si"), ...)
}
\arguments{
\item{symbol}{byte symbol to use. If "auto" the symbol used will be
determined by the maximum value of \code{x}. Valid symbols are
"b", "Kb", "Mb", "Gb", "Tb", "Pb",
"Eb", "Zb", and "Yb", along with their upper case
equivalents and "iB" equivalents.}

\item{units}{which unit base to use, "binary" (1024 base) or
"si" (1000 base) for ISI units.}

\item{...}{other arguments passed to \code{\link[=number]{number()}}}

\item{x}{a numeric vector to format}
}
\value{
a function with three parameters, \code{x``, a numeric vector that returns a character vector,}symbol\code{the byte symbol (e.g. "Kb") desired and the measurement}units\code{(traditional}binary\code{or}si` for ISI metric units).
}
\description{
Bytes formatter: convert to byte measurement and display symbol.
}
\examples{
number_bytes_format()(sample(3000000000, 10))
number_bytes(sample(3000000000, 10))
number_bytes(sample(3000000000, 10), accuracy = .1)
}
\references{
Units of Information (Wikipedia) :
\url{http://en.wikipedia.org/wiki/Units_of_information}
}
