% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatter.r
\name{dollar_format}
\alias{dollar}
\alias{dollar_format}
\title{Currency formatter: round to nearest cent and display dollar sign.}
\usage{
dollar_format(prefix = "$", suffix = "", largest_with_cents = 1e+05, ...,
  big.mark = ",", negative_parens = FALSE)

dollar(x)
}
\arguments{
\item{prefix, suffix}{Symbols to display before and after amount.}

\item{largest_with_cents}{the value that all values of \code{x} must
be less than in order for the cents to be displayed}

\item{...}{Other arguments passed on to \code{\link{format}}.}

\item{big.mark}{Character used between every 3 digits.}

\item{negative_parens}{Should negative values be shown with parentheses?}

\item{x}{a numeric vector to format}
}
\value{
a function with single parameter x, a numeric vector, that
  returns a character vector
}
\description{
The returned function will format a vector of values as currency.
Values are rounded to the nearest cent, and cents are displayed if
any of the values has a non-zero cents and the largest value is less
than \code{largest_with_cents} which by default is 100000.
}
\examples{
dollar_format()(c(-100, 0.23, 1.456565, 2e3))
dollar_format()(c(1:10 * 10))
dollar(c(100, 0.23, 1.456565, 2e3))
dollar(c(1:10 * 10))
dollar(10^(1:8))

usd <- dollar_format(prefix = "USD ")
usd(c(100, -100))

euro <- dollar_format(prefix = "", suffix = "\\u20ac")
euro(100)

finance <- dollar_format(negative_parens = TRUE)
finance(c(-100, 100))
}

