% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{silhouette_width}
\alias{silhouette_width}
\title{batch_sil}
\usage{
silhouette_width(reduction, meta.data, keys)
}
\arguments{
\item{reduction}{a matrix of reduced dimensions}

\item{meta.data}{dataframe with meta.data associated with reduction}

\item{keys}{columns in meta.data to calculate silhoette for
to use (default: all)}
}
\value{
The average silhouette width for all clusters.
    For batch effect, the smaller the better.
    For biological effect, the larger the better.
}
\description{
Determine batch/bio effect using the silhouette
    coefficient (adopted from scone):
}
\examples{

## calculate the the silhoeuette width score on two sets of labels
## NOTE: this requires computation of a distance matrix, so does not
##       scale well to large datasets
data(sceiad_subset_data)
features <- sceiad_subset_data[, paste0('scviDim_', 1:8)]
metadata <- sceiad_subset_data[,c('Barcode', 'cluster',
              'subcluster', 'CellType', 'CellType_predict')]
silhouette_width(features, metadata, 'CellType_predict')

}
