% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gsea.R
\name{run_fgsea}
\alias{run_fgsea}
\title{Run fgsea for one cell type of one factor}
\usage{
run_fgsea(
  container,
  factor_select,
  ctype,
  db_use = "GO",
  signed = TRUE,
  ncores = container$experiment_params$ncores
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{factor_select}{numeric The factor of interest}

\item{ctype}{character The cell type of interest}

\item{db_use}{character The database of gene sets to use. Database
options include "GO", "Reactome", "KEGG", "BioCarta", and "Hallmark". More than
one database can be used. (default="GO")}

\item{signed}{logical If TRUE, uses signed gsea. If FALSE, uses unsigned gsea.
Currently only works with fgsea method. (default=TRUE)}

\item{ncores}{numeric The number of cores to use (default=container$experiment_params$ncores)}
}
\value{
A data.frame of the fgsea results for enrichment of gene sets in a given
cell type for a given factor. The results contain adjusted p-values, normalized
enrichment scores, leading edge genes, and other information output by fgsea.
}
\description{
Run fgsea for one cell type of one factor
}
