% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/LIGER_Utilities.R,
%   R/QC_Utilities_Seurat.R
\name{Add_Cell_Complexity}
\alias{Add_Cell_Complexity}
\alias{Add_Cell_Complexity.liger}
\alias{Add_Cell_Complexity.Seurat}
\title{Add Cell Complexity}
\usage{
Add_Cell_Complexity(object, ...)

\method{Add_Cell_Complexity}{liger}(
  object,
  meta_col_name = "log10GenesPerUMI",
  overwrite = FALSE,
  ...
)

\method{Add_Cell_Complexity}{Seurat}(
  object,
  meta_col_name = "log10GenesPerUMI",
  assay = "RNA",
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{object}{Seurat or LIGER object}

\item{...}{Arguments passed to other methods}

\item{meta_col_name}{name to use for new meta data column.  Default is "log10GenesPerUMI".}

\item{overwrite}{Logical.  Whether to overwrite existing an meta.data column.  Default is FALSE meaning that
function will abort if column with name provided to \code{meta_col_name} is present in meta.data slot.}

\item{assay}{assay to use in calculation.  Default is "RNA".  \emph{Note} This should only be changed if
storing corrected and uncorrected assays in same object (e.g. outputs of both Cell Ranger and Cell Bender).}
}
\value{
An object of the same class as \code{object} with columns added to object meta data.
}
\description{
Add measure of cell complexity/novelty (log10GenesPerUMI) for data QC.
}
\examples{
\dontrun{
# Liger
liger_object <- Add_Cell_Complexity(object = liger_object)
}

# Seurat
library(Seurat)
pbmc_small <- Add_Cell_Complexity(object = pbmc_small)

}
\concept{liger_object_util}
\concept{qc_util}
