#' Ensembl Mito IDs
#'
#' A list of ensembl ids for mitochondrial genes (Ensembl version 105)
#'
#' @format A list of six vectors
#' \describe{
#'   \item{Mus_musculus_mito_ensembl}{Ensembl IDs for mouse mitochondrial genes}
#'   \item{Homo_sapiens_mito_ensembl}{Ensembl IDs for human mitochondrial genes}
#'   \item{Danio_rerio_mito_ensembl}{Ensembl IDs for zebrafish mitochondrial genes}
#'   \item{Rattus_norvegicus_mito_ensembl}{Ensembl IDs for rat mitochondrial genes}
#'   \item{Drosophila_melanogaster_mito_ensembl}{Ensembl IDs for fly mitochondrial genes}
#'   \item{Macaca_mulatta_mito_ensembl}{Ensembl IDs for macaque mitochondrial genes}
#'
#' }
#' @concept data
#'
"ensembl_mito_id"


#' Ensembl Ribo IDs
#'
#' A list of ensembl ids for ribosomal genes (Ensembl version 105)
#'
#' @format A list of seven vectors
#' \describe{
#'   \item{Mus_musculus_ribo_ensembl}{Ensembl IDs for mouse ribosomal genes}
#'   \item{Homo_sapiens_ribo_ensembl}{Ensembl IDs for human ribosomal genes}
#'   \item{Callithrix_jacchus_ribo_ensembl}{Ensembl IDs for marmoset ribosomal genes}
#'   \item{Danio_rerio_ribo_ensembl}{Ensembl IDs for zebrafish ribosomal genes}
#'   \item{Rattus_norvegicus_ribo_ensembl}{Ensembl IDs for rat ribosomal genes}
#'   \item{Drosophila_melanogaster_ribo_ensembl}{Ensembl IDs for fly ribosomal genes}
#'   \item{Macaca_mulatta_ribo_ensembl}{Ensembl IDs for macaque ribosomal genes}
#'
#' }
#' @concept data
#'
"ensembl_ribo_id"
