% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{Meta_Highlight_Plot}
\alias{Meta_Highlight_Plot}
\title{Meta Highlight Plot}
\usage{
Meta_Highlight_Plot(
  seurat_object,
  meta_data_column,
  meta_data_highlight,
  highlight_color = NULL,
  background_color = "lightgray",
  pt.size = NULL,
  raster = NULL,
  raster.dpi = c(512, 512),
  label = FALSE,
  split.by = NULL,
  split_seurat = FALSE,
  ggplot_default_colors = FALSE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{meta_data_column}{Name of the column in \code{seurat_object@meta.data} slot to pull value from for highlighting.}

\item{meta_data_highlight}{Name of variable(s) within \code{meta_data_name} to highlight in the plot.}

\item{highlight_color}{Color to highlight cells (default "navy").}

\item{background_color}{non-highlighted cell colors.}

\item{pt.size}{point size for both highlighted cluster and background.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{label}{Whether to label the highlighted meta data variable(s).  Default is FALSE.}

\item{split.by}{Variable in \verb{@meta.data} to split the plot by.}

\item{split_seurat}{logical.  Whether or not to display split plots like Seurat (shared y axis) or as
individual plots in layout.  Default is FALSE.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{...}{Extra parameters passed to\code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Create Plot with meta data variable of interest highlighted
}
\examples{
library(Seurat)
pbmc_small$sample_id <- sample(c("sample1", "sample2"), size = ncol(pbmc_small), replace = TRUE)

Meta_Highlight_Plot(seurat_object = pbmc_small, meta_data_column = "sample_id",
meta_data_highlight = "sample1", highlight_color = "gold", background_color = "lightgray",
pt.size = 2)

}
\concept{seurat_plotting}
