% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_replace_files.R
\name{item_replace_files}
\alias{item_replace_files}
\title{Replace files associated with an item}
\usage{
item_replace_files(sb_id, files, ..., all = FALSE, scrape_files = FALSE)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{files}{A character vector of file paths}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}

\item{all}{A boolean indicating if all attached files should be removed before
uploading new files. FALSE if only files with matching names should be replaced. 
If you wish to upload files with duplicate names, see \code{\link{item_append_files}}.
Defaults to FALSE.}

\item{scrape_files}{logical should the files be scraped for metadata? 
If TRUE, sciencebase will attempt to create extensions based on the files.

For example, for shapefiles, this will result in a shapefile extension 
to be returned as a facet of the sciencebase item. 
See item: "58069258e4b0824b2d1d422e" for an example.}
}
\description{
replaces existing files associated with an item with a new one. 
  
NOTE: This function will not replace files stored in facets. Until and if 
facet support is added, direct alteration of the science base item object 
is required to manipulate facets.
}
