% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convRad2Ref.R
\docType{methods}
\name{convRad2Ref}
\alias{convRad2Ref}
\alias{convRad2Ref,Satellite-method}
\alias{convRad2Ref,RasterStack-method}
\alias{convRad2Ref,RasterLayer-method}
\title{Convert a band's scaled counts or radiance values to reflectance}
\usage{
\S4method{convRad2Ref}{Satellite}(x, szen_correction = "TRUE")

\S4method{convRad2Ref}{RasterStack}(x, mult, add, szen)

\S4method{convRad2Ref}{RasterLayer}(x, mult, add, szen)
}
\arguments{
\item{x}{An object of class Satellite, raster::RasterStack or 
raster::RasterLayer providing radiance values.}

\item{szen_correction}{Logical; if \code{TRUE}, sun zenith correction is 
being applied.}

\item{mult}{Multiplicative coefficient for value transformation (i.e. slope).}

\item{add}{Additive coefficient for value transformation (i.e. offset)}

\item{szen}{Cosine of solar zenith angle.}
}
\value{
If x is a Satellite object, a Satellite object with added converted 
layers; \cr
if x is a \code{raster::Raster*} object, a \code{raster::Raster*} object with 
converted layer(s).
}
\description{
Convert a band's scaled counts to reflectance using a simple linear 
conversion without any kind of atmospheric correction etc.
}
\details{
The conversion functions are taken from USGS' Landsat 8 manual
which is available online at 
\url{http://landsat.usgs.gov/Landsat8_Using_Product.php}.

If the sensor does not provide linear conversion coefficients for reflectance
computation, the reflectance is calculated using the solar irradiance 
following the functions taken from USGS' Landsat 7 manual, chapter 11.3.2,
which is available online at 
\url{https://landsat.gsfc.nasa.gov/wp-content/uploads/2016/08/Landsat7_Handbook.pdf}.
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)  
sat <- convRad2Ref(sat)

# If you use a raster layer, supply required meta information
bcde <- "B002n"
convRad2Ref(x = getSatDataLayer(sat, bcde),
            mult = getSatRADM(sat, bcde),
            add = getSatRADA(sat, bcde))

}
\seealso{
\code{\link{calcAtmosCorr}} for conversions of scaled counts 
to physical units including a scene-based atmospheric correction.
}
