% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_average.R
\name{sar_pred}
\alias{sar_pred}
\title{Use SAR model fits to predict richness on islands of a given size}
\usage{
sar_pred(fit, area)
}
\arguments{
\item{fit}{Either a model fit object, a fit_collection object (generated
using \code{\link{sar_multi}}), or a sar_multi object (generated using
\code{\link{sar_average}}).}

\item{area}{A numeric vector of area values (length >= 1).}
}
\value{
A data.frame of class 'sars' with three columns: 1) the name of the
  model, 2) the area value for which a prediction has been generated, and 3)
  the prediction from the model extrapolation.
}
\description{
Predict the richness on an island of a given size using either
  individual SAR model fits, a fit_collection of model fits, or a multi-model
  SAR curve.
}
\details{
Extrapolation (e.g. predicting the richness of areas too large to be
  sampled) is one of the primary uses of the SAR. The \code{sar_pred}
  function provides an easy method for undertaking such an exercise. The
  function works by taking an already fitted SAR model, extacting the
  parameter values and then using these values and the model function to
  predict the richness for any value of area provided.

  If a multi-model SAR curve is used for prediction (i.e. using
  \code{\link{sar_average}}), the model information criterion weight (i.e.
  the conditional probabilities for each of the n models) for each of the
  individual model fits that were used to generate the curve are stored. The
  n models are then each used to predict the richness of a larger area and
  these predictions are multiplied by the respective model weights and summed
  to provide a multi-model averaged prediction.
}
\note{
This function is used in the ISAR extrapolation paper of Matthews &
  Aspin (2019).

  Code to calculate confidence intervals around the predictions using
  bootstrapping will be added in a later version of the package.
}
\examples{
data(galap)
#fit the power model and predict richness on an island of area = 5000
fit <- sar_power(data = galap)
p <- sar_pred(fit, area = 5000)

#fit three SAR models and predict richness on islands of area = 5000 & 10000
fit2 <- sar_multi(galap, obj = c("power", "loga", "koba"))
p2 <- sar_pred(fit2, area = c(5000, 10000))

#calculate a multi-model curve and predict richness on islands of area = 5000 & 10000
fit3 <- sar_average(data = galap)
p3 <- sar_pred(fit3, area = c(5000, 10000))
}
\references{
Matthews, T.J. & Aspin, T.W.H. (2019) ....
}
