% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/char2numAspect.R
\name{char2numAspect}
\alias{char2numAspect}
\title{Conversion of character Aspects to numeric Aspects}
\usage{
char2numAspect(charAspect)
}
\arguments{
\item{charAspect}{Character string of aspect location, i.e., one of
\itemize{
\item \code{c("N", "NE", "NNE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW")}
}}
}
\value{
Float value of numeric aspect location, North = 0 degree, S = 180 degree
}
\description{
Convert character aspects (of snow profile locations) to numeric values.
For example, Aspect "N" (north) becomes 0 degrees azimuth.
}
\examples{
char2numAspect("W")
char2numAspect("WNW")

char2numAspect(c("N", NA, "NA", "NE"))

}
\author{
fherla
}
