% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medoidSP.R
\name{medoidSP}
\alias{medoidSP}
\title{Find the medoid snow profile among a group of profiles}
\usage{
medoidSP(SPx, distmat = NULL, clustering = NULL, keepDistmat = FALSE, ...)
}
\arguments{
\item{SPx}{a \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} object}

\item{distmat}{If you have a precalculated distance matrix, provide it here to compute the medoid on it.}

\item{clustering}{index of clusters, if provided instead of identifying the medoid profile of the entire snowprofileSet it will
return a vector of medoids for each cluster}

\item{keepDistmat}{Do you want to return the pairwise distance matrix?}

\item{...}{arguments passed to \link{distanceSP} and then further to \link{dtwSP} and \link{simSP}}
}
\value{
If \code{keepDistmat = FALSE} return the (named) index of the medoid snow profile, otherwise return a list with the elements
\code{id.med} and \code{distmat}.
}
\description{
Find the medoid snowprofile among a group of profiles, based on their pairwise dissimilarity. Either provide a list
of \code{snowprofile} objects, or a precomputed distance matrix.
}
\details{
If  providing a large number of profiles without a precomputed distance matrix consider providing a \code{ncores}
argument so \code{distanceSP} will calculate alignments in parallel.
}
\examples{
this_example_runs_about_5s <- TRUE
if (!this_example_runs_about_5s) {  # exclude from cran checks

## take a list of profiles
grouplist <- SPgroup2[1:4]
plot(grouplist, SortMethod = 'unsorted', xticklabels = "originalIndices")

## calulate medoid profile
id.med <- medoidSP(grouplist)
representativeProfile <- grouplist[[id.med]]
plot(representativeProfile, main = paste0("medoid (i.e., profile ", id.med, ")"))

}
}
\author{
fherla shorton
}
