% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeme_helpers.R
\name{process_crowd_data}
\alias{process_crowd_data}
\title{Process Data for a Single Crowd}
\usage{
process_crowd_data(
  crwd,
  args,
  omitted_cols_list,
  kept_indep_cats_list,
  data,
  mesos_var,
  mesos_group,
  ...
)
}
\arguments{
\item{crwd}{Character string identifying the current crowd}

\item{args}{List of makeme function arguments}

\item{omitted_cols_list}{Named list of omitted variables for each crowd}

\item{kept_indep_cats_list}{Named list of kept independent categories for each crowd}

\item{data}{Data frame being analyzed}

\item{mesos_var}{Mesos-level grouping variable}

\item{mesos_group}{Specific mesos group identifier}

\item{...}{Additional arguments passed to data summarization functions}
}
\value{
Final output object for the crowd, or NULL if no data remains:
\itemize{
\item Plot, table, or other analysis object depending on type
\item NULL if crowd has no valid data after filtering
}
}
\description{
Internal helper function that handles the complete processing pipeline
for a single crowd, from data filtering to final output generation.
}
\details{
Complete processing pipeline:
\itemize{
\item Calculates omitted variables for the crowd
\item Filters data by crowd membership and variable exclusions
\item Applies independent category filtering if enabled
\item Detects variable types and generates data summary
\item Performs validation and post-processing
\item Generates final output via make_content()
}
}
\keyword{internal}
