
## Do not edit this file manually.
## It has been automatically generated from *.org sources.

coreXarmaFilter <- function(x, eps, ar = numeric(0), ma = numeric(0),
                            p = length(ar), q = length(ma), n = length(x),
                            from = max(p,q) + 1, intercept = 0){
    if(q > 0){
        ceps <- filter(eps, c(1, ma), sides = 1L)    # prepend '1' to the coef's.
        ## 2016-11-20 commenting out.
        ##     (a) filter() sets ceps[1:q] to NA.
        ##     (b) if from > q, ceps[1:q] is ignored, see below, so the values don't matter.
        ## ceps[1:q] <- 0
    }else{
        ceps <- eps
    }
                    # intercept can be a constant or a vector of same length as ceps (ie x)
# browser()

    ceps <- ceps + intercept

    if(p > 0){
        init <- x[(from - 1):(from - p)] # filter() requires init in reverse order;
                                         # TODO: check!
                       # notice: for "recursive", don't prepend '1' to 'ar'
        ceps[from:n] <- filter(ceps[from:n], ar, method = "recursive", init = init)
    }

    x[from:n] <- ceps[from:n]
    x
}

xarmaFilter <- function(model, x = numeric(length(eps)), eps = numeric(length(x)),
                        from = NULL, whiten = FALSE,
                        xcenter = NULL, xintercept = NULL){
                         # 2014-02-01 changing to "[[" to avoid partial matching for "p", etc.
                         #            which was a long standing cause of puzzling errors.
    ar        <- model[["ar",        exact = TRUE]] # model$ar
    ma        <- model[["ma",        exact = TRUE]] # model$ma
    center    <- model[["center",    exact = TRUE]] # model$center
    intercept <- model[["intercept", exact = TRUE]] # model$intercept
       # TODO: replace the above with:
       #    list2env(model, envir = environment()) # but need to change some is.null() below
       # (no, if this is user facing function.)

    p <- length(ar)
    q <- length(ma)

    if(is.null(from))                             # set a value for "from" if not supplied
        from <- 1 + max(p,q)
    else if(from <= max(p,q))
        stop("'from' must be greater than max(p,q)")

    n <- length(x)

    ct <- if(is.null(intercept)) 0  else intercept
    if(!is.null(xintercept))
        ct <- xintercept + ct

    if(is.null(center) && is.null(xcenter)){
        flag.center <- FALSE
        y <- x
    }else{
        flag.center <- TRUE
        mu <- if(is.null(xcenter)) 0 else xcenter
        if(!is.null(center))
  	    mu <-  mu + center

        y <- x - mu
    }

    if(is.null(eps)){ # set initial values of eps to zero.  copy 'x' to keep the attributes
                      # of x, eg if x is a "ts" object, and ensure consistency of returned
                      # value in the two cases for 'whiten'
        eps <- x
        eps[] <- 0    # makes sense mostly when whiten = TRUE
    }


    if(whiten){ # compute residuals (whiten the series x if x is arma with these params)
        eps <- coreXarmaFilter(x = eps, eps = y, ar = - ma, ma = - ar,
                               p = q, q = p, n = n, from = from, intercept = - ct )
        eps
    }else{      # compute a series from given residuals ("colour"/unwhiten eps)
        y <- coreXarmaFilter(x = y, eps = eps, ar = ar, ma = ma,
                             p = p, q = q, n = n, from = from, intercept = ct )

        x[from:n] <- if(flag.center) (y+mu)[from:n]  # add back the center
                     else               y[from:n]
        x
    }
}

## TODO: use filtmodel$sigma2 ? Two problems with this:
##       (a) currently sim_sarima doesn't look into components of 'model' (minor issue).
##       (b) if the user supplies his own eps, should I multiply it by sigma2?
##           A reasonable default approach might be if model$sigma2 is NA or NULL
##            not to do it (and/or introduce an argument to give the user a choice).
## based on sim_pc from 'pcts'                                                                     # innov = rand.gen(,,...)
sim_sarima <- function(model, n = NA, rand.gen = rnorm,
                   n.start = NA, x, eps, xcenter = NULL, xintercept = NULL, ...){
    from <- n.drop <- NULL
    wrk <- .prepare_x_eps(x, eps, n = n, n.start = n.start, xintercept = xintercept, ...)
        # for(varname is names(wrk)){ # make explicit later
        #     assign(varname, wrk$varname)
        # }
    list2env(wrk, environment()) ## todo: check

    filtmodel <- model2filter(model)

    x <- if(from == 1)
             xarmaFilter(filtmodel, x, eps, xcenter = xcenter, xintercept = xintercept)
         else
             xarmaFilter(filtmodel, x, eps, from = from, xcenter = xcenter,
	                 xintercept = xintercept)

    if(n.drop > 0 )
        x[-(1:n.drop)]  # TODO: keep class of x?
    else
        x
}

model2filter <- function(model){
    ## TODO: currently assumes 'model' is a list
    ## TODO: make this conditional
    sarima <- do.call("new", c(list("SarimaModel"), model))

        # modelCoef() first to expand the polynomials
    co <- as(modelCoef(sarima, "ArmaModel"), "list")
    list(ar = co$ar, ma = co$ma,
         sigma2 = sarima@sigma2,
         center = sarima@center, intercept = sarima@intercept)
}

## helper function - ensure that the argument is a list with components
##        before, init and main (maybe NULL's)
.beforeInitMain <- function(x){
    res <- list(before = numeric(0), init = numeric(0), main = numeric(0))

    if(missing(x) || is.null(x))
        res
    else if(class(x) == "list"){  # TODO: use inherits()?
                        #  x[c("before", "init", "main")] would return elements named <NA>
                        #  for absent components
        list(before = x$before, init = x$init, main = x$main)
        if(!is.null(x$before)) res$before <- x$before
        if(!is.null(x$init)) res$init <- x$init
        if(!is.null(x$main)) res$main <- x$main
        res
    }else{
        res$main <- x
        res
    }
}

## TODO: var of innovations is implicit in "...", deal with it better?
prepareSimSarima <- local({
    ## these variables will be shadowed by list2env().
    ## The aim is somewhat more clear code; 'R CMD check' also is happier.
    x <- eps <- NULL
    ar <- ma <- numeric(0)
    p <- q <- 0
    from <- NULL # TODO: rethink!

           # the default for n.start is NA, so that in future automatic choice may be offered
    function(model, x = NULL, eps = NULL, n, n.start = NA, xintercept = NULL,
             rand.gen = rnorm){

        eps <- .beforeInitMain(eps)
        x <- .beforeInitMain(x)
        ct <- .beforeInitMain(xintercept)

        if(length(eps$before) != length(x$before)){
            if(length(eps$before) == 0)
                eps$before <- numeric(length(x$before))
            else if(length(x$before) == 0)
                x$before <- numeric(length(eps$before))
            else
                stop("Lengths of xbefore and innovbefore must be equal if both are present.")
        }

        if(length(eps$init) != length(x$init)){
            if(length(eps$init) == 0)
                eps$init <- numeric(length(x$init))
            else if(length(x$init) == 0)
                x$init <- numeric(length(eps$init))
            else
                stop("Lengths of xinit and innovinit must be equal if both are present.")
        }

        n.before <- length(x$before)

        if(is.na(n.start))
            n.start <- 0

        if(missing(n) || is.null(n))
            n <- length(eps$main) + length(eps$init) - n.start
        else{ # adjust x$main and eps$main
            eps$main <- c(eps$main,
                          numeric(n.start + n - length(eps$init) - length(eps$main)) )
            x$main <- c(x$main,
                          numeric(n.start + n - length(x$init) - length(x$main)) )
        }

        from <- 1 + length(x$before) + length(x$init)
        n.drop <- n.before + n.start


## browser()

            # if(is.null(innov)){
            #     eps <- rand.gen(n.start + n, ...)
            #     if(length(innovinit) > 0)
            #         eps <- eps[-(1:length(innovinit))]
            # }else if(length(innov) == n.start + n - length(innovinit))
            #     eps <- innov
            # else
            #   stop("length(innov) is not compatible with n.start,n and length(innovinit).")


        ## TODO: use new variables further below; for now save the old values in eps0,x0
	eps0 <- eps
	x0 <- x

        eps <- c(eps$before, eps$init, eps$main )
        x   <- c(x$before, x$init, numeric(n.start + n - length(x$init)))

        ctt <- if(length(ct$main) == 0)
                   0
               else if(length(ct$main) == 1){  # constant xintercept
                   ct$main
               }else if(length(ct$main) > 1){  # non-constant xintercept
                   if(length(ct$before) == 0) # TODO: NA on place of 0?
                       ct$before <- numeric(length(eps0$before))
                   if(length(ct$init) == 0)
                       ct$init <- numeric(length(eps0$init))

                   c(ct$before, ct$init, ct$main)
               }

        stopifnot(length(x) == length(eps),
                  length(ctt) == 1  ||  length(ctt) == length(eps)
                  )

        filtmodel <- model2filter(model)

        ar <- filtmodel$ar
        ma <- filtmodel$ma
        mu <- filtmodel$center
        intercept <- filtmodel$intercept

        sigma <- sqrt(filtmodel$sigma2)

        p <- length(ar)
        q <- length(ma)

        if(intercept != 0)
            ctt <- ctt + intercept

        flag.center <- mu == 0
        n0 <- n
        rand.gen0 <- match.fun(rand.gen)


	## TODO: tryabat po-palna proverka na razmernostite!

        ## TODO: drugi varianti, kontrolirani s argument or otherwise;
        ##      e.g., use sepaeate functions instead of conditionals
        f <- function(n = n0, rand.gen, ...){
            if(missing(rand.gen))
                rand.gen <- rand.gen0
            nx <- length(x)

            eps.main <- sigma * rand.gen(n.start + n, ...)
	    eps <- c(eps[1:(from-1)], eps.main)
            ## TODO: may need to modify x if n != n0

            if(flag.center)
                y <- x
            else
                y <- x - mu

            y <- coreXarmaFilter(x = y, eps = eps, ar = ar, ma = ma, p = p, q = q, # n = n,
                                 from = from, intercept = ctt )

            x[from:nx] <- if(flag.center) (y+mu)[from:nx]
                         else               y[from:nx]
            x # TODO: return x[-(1:n.drop)] ?
        }
	class(f) <- "simSarimaFun"
        f
    }
})

print.simSarimaFun <- function(x, ...){
    print("A function for simulation of the following Sarima model.")

    e <- environment(x)

    print(e$model) # TODO: do this more friendly.

    print("The parameters of the simulation are:")
    print("TODO: this print method is unfinished.")

    invisible(NULL)
}

## based on sim_pc() in pcts
## TODO: should this deal with simulation?
.prepare_x_eps <- function(x = NULL, eps = NULL, n, n.start = NA, xintercept = NULL,
                           rand.gen = rnorm, ...){

    if(missing(eps) || is.null(eps)){
        innovbefore <- NULL
        innovinit   <- NULL
        innov       <- NULL
    }else if( class(eps)=="list" ){  ## TODO: use inherits()
        innovbefore <- eps$before
        innovinit   <- eps$init
        innov       <- eps$main
    }else{
        innovbefore <- NULL
        innovinit   <- NULL
        innov       <- eps
    }

    if(missing(x) || is.null(x)){
        xbefore <- NULL
        xinit   <- NULL
    }else if( class(x)=="list" ){
        xbefore <- x$before
        xinit   <- x$init
    }else{
        xbefore <- x    # dali tova e estestveno?
        xinit   <- NULL
    }

    if(missing(xintercept)){
        ct.before <- NULL
        ct.init   <- NULL
        ct        <- NULL
    }else if( class(xintercept)=="list" ){
        ct.before <- xintercept$before
        ct.init   <- xintercept$init
        ct        <- xintercept$main
    }else{
        ct.before <- NULL
        ct.init   <- NULL
        ct        <- xintercept
    }

    if(is.na(n.start)) # the default is NA, so that in future automatic choice may be offered
        n.start <- 0

    if(       is.null(innovbefore)  &&  !is.null(xbefore) )
        innovbefore <- numeric(length(xbefore))
    else if( !is.null(innovbefore)  &&   is.null(xbefore) )
        xbefore <- numeric(length(innovbefore))
    else if(  is.null(innovbefore)  &&   is.null(xbefore) )
        innovbefore <- xbefore <- numeric(0)
    else if( !is.null(innovbefore)  &&  !is.null(xbefore) )
        if(length(innovbefore) != length(xbefore) )
            stop("Lengths of xbefore and innovbefore must be equal if both are present.")

    if(       is.null(innovinit)  &&  !is.null(xinit) )
        innovinit <- numeric(length(xinit))
    else if( !is.null(innovinit)  &&   is.null(xinit) )
        xinit <- numeric(length(innovinit))
    else if(  is.null(innovinit)  &&   is.null(xinit) )
        innovinit <- xinit <- numeric(0)
    else if( !is.null(innovinit)  &&  !is.null(xinit) )
        if(length(innovinit) != length(xinit) )
            stop("Lengths of xinit and innovinit must be equal if both are present.")

    n.before <- length(xbefore)
    if( is.null(ct.before) ) ct.before <- numeric(length(xbefore))
    if( is.null(ct.init) )   ct.init   <- numeric(length(xinit))

    ## if(is.na(n))
    ##     n <- ?

    if(is.null(innov)){
        eps <- rand.gen(n.start + n, ...)
        if(length(innovinit) > 0)
            eps <- eps[-(1:length(innovinit))]
    }else if(length(innov) == n.start + n - length(innovinit))
        eps <- innov
    else
        stop("length(innov) is not compatible with n.start,n and length(innovinit).")

    eps <- c(innovbefore, innovinit, eps )
    x   <- c(xbefore, xinit, numeric(n.start + n - length(xinit)))
    ctt <- if(is.null(ct))
               NULL
           else
               c(ct.before, ct.init, ct )

    stopifnot(length(x) == length(eps),
              is.null(ctt) || length(eps) == length(ctt)
              )

    list(x = x, eps = eps, xintercept = ctt,
         from = 1 + length(xbefore) + length(xinit),
         n.drop = n.before + n.start )
}

sarima.f <- function(past = numeric(length(ar)),
                     n = max(2*length(past),12),
                     ar = numeric(0), ma = numeric(0),
                     intercept = 0,
                     pasteps = numeric(length(ma)), trend = numeric(n)){
    p <- length(ar)
    q <- length(ma)
    m <- max(p,q)

    if(length(past) > m) # keep only m past values
        past <- past[length(past) + (-m+1):0]

    res <- c(numeric(max(m-p,0)), past, numeric(n))

    if(length(pasteps) > m) # keep only m past values
        pasteps <- past[length(pasteps) + (-m+1):0]
    eps <- c(numeric(max(m-q,0)), pasteps, numeric(n))  # more care needed


    trend <- c(numeric(m), trend)

    for(i in  m + (1:n) ){
        res[i] <- intercept + trend[i] + eps[i]
        if(p>0)
            for(j in 1:p){
                res[i] <- res[i] + ar[j]*res[i-j]
            }
        if(q>0)
            for(j in 1:q){
                res[i] <- res[i] + ma[j]*eps[i-j]
            }
    }

    res[-(1:m)]             # Return the forecasts only.
}

fun.forecast <- function(  past
                         , n=max(2*length(past),12)
                         #, trend = numeric(n)
                         , eps = numeric(n)
                         , pasteps
                         , ...
                         ){
    ## model <- sarima.mod(...)
    sarima <- new("SarimaModel", ...)

    co <- filterCoef(sarima, new("ArmaFilter"))
    ar = co$ar
    ma = co$ma
    center = sarima@center
    intercept = sarima@intercept

    if(missing(past))
        past <-  numeric(length(ar))

    if(missing(pasteps))
        pasteps <-  numeric(length(ma))

    fullintercept <- intercept
    if(center != 0 && sarima@iorder == 0 && sarima@siorder == 0) # Why only in this case?
                                       # (ans: because otherwise (1 - sum(ar) ) = 0)
        fullintercept <- intercept + (1-sum(ar)) * center

    res <- sarima.f(past = past, n = n, ar = ar, ma = ma
                  , intercept = fullintercept
                  , pasteps = pasteps
                  )                                                # trend=
    ts(res)         # Return the forecasts only.  TODO: set period?
}

## ## for now use sim_sarima as default
## simSarima <- sim_sarima
##
## setGeneric("simSarima", signature = c("model"))
##
## 2016-10-26 commenting out temporarily after removal of arCoef and maCoef
##
## setMethod("simSarima", "ArmaModel",
##           function(model, init = NULL, rand.gen = rnorm, info = "print", ...){
##               mo <- sarima.mod(ar = arCoef(model), ma = maCoef(model), mean = mean(model))
##               sim_sarima(model = mo, ...)
##           }
##           )
