% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{norm_diurnal_centroid}
\alias{norm_diurnal_centroid}
\title{Normalized diurnal centroid calculation}
\usage{
norm_diurnal_centroid(sapf_var, rad_var)
}
\arguments{
\item{sapf_var}{A numeric vector containing the sapflow values for a day at a
regular intervals. Missing values are allowed but not recommended.}

\item{rad_var}{A numeric vector containing the incoming radiation for a day
at a regular intervals. Missing values are allowed but not recommended.
Must be the same length as sapf_var.}
}
\value{
A numeric value with the normalized diurnal centroid value
}
\description{
Calculate the normalized diurnal centroid for sapflow variables
}
\details{
The code for this function has been kindly provided by Jacob Nelson in python
(see https://github.com/jnelson18/FluxnetTools/blob/master/FileS3.py) and has
been translated to a tidy data phylosophy in R to be used inside a
\code{\link[dplyr]{summarise}} statement.
}
\section{Normalized diurnal centroid algorithm}{

This function calculates the diurnal centroid of sapflow measures
\emph{relative} to the diurnal centroid of incoming radiation (in any units).
For that the incoming radiation diurnal centroid is substracted from the
sapflow diurnal centroid:

\deqn{
Sapf_cent - IncomingRad_cent
}
}

\author{
Jacob Nelson & Víctor Granda
}
