% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_pretty}
\alias{chop_pretty}
\alias{brk_pretty}
\alias{tab_pretty}
\title{Chop using pretty breakpoints}
\usage{
chop_pretty(x, n = 5, ...)

brk_pretty(n = 5, ...)

tab_pretty(x, n = 5, ...)
}
\arguments{
\item{x}{A vector.}

\item{n}{Positive integer passed to \code{\link[base:pretty]{base::pretty()}}. How many intervals to chop into?}

\item{...}{Passed to \code{\link[=chop]{chop()}} by \code{chop_pretty()} and \code{tab_pretty()}; passed
to \code{\link[base:pretty]{base::pretty()}} by \code{brk_pretty()}.}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_pretty()} uses \code{\link[base:pretty]{base::pretty()}} to calculate breakpoints
which are 1, 2 or 5 times a power of 10. These look nice in graphs.
}
\details{
\code{\link[base:pretty]{base::pretty()}} tries to return \code{n+1} breakpoints, i.e. \code{n} intervals, but
note that this is not guaranteed. There are methods for Date and POSIXct
objects.

For fine-grained control over \code{\link[base:pretty]{base::pretty()}} parameters, use
\code{chop(x, brk_pretty(...))}.
}
\examples{
chop_pretty(1:10)

chop(1:10, brk_pretty(n = 5, high.u.bias = 0))

tab_pretty(1:10)

}
