% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/tab.R
\name{chop}
\alias{chop}
\alias{kiru}
\alias{tab}
\title{Cut data into intervals}
\usage{
chop(
  x,
  breaks,
  labels = lbl_intervals(),
  extend = NULL,
  left = TRUE,
  close_end = FALSE,
  drop = TRUE
)

kiru(
  x,
  breaks,
  labels = lbl_intervals(),
  extend = NULL,
  left = TRUE,
  close_end = FALSE,
  drop = TRUE
)

tab(
  x,
  breaks,
  labels = lbl_intervals(),
  extend = NULL,
  left = TRUE,
  close_end = FALSE,
  drop = TRUE
)
}
\arguments{
\item{x}{A vector.}

\item{breaks}{A numeric vector of cut-points or a function to create
cut-points from \code{x}.}

\item{labels}{A character vector of labels or a function to create labels.}

\item{extend}{Logical. Extend breaks to \verb{+/-Inf}?}

\item{left}{Logical. Left-closed breaks?}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}

\item{drop}{Logical. Drop unused levels from the result?}
}
\value{
\code{chop()} returns a \code{\link{factor}} of the same length as \code{x}, representing the
intervals containing the value of \code{x}.

\code{tab()} returns a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop()} cuts \code{x} into intervals. It returns a \code{\link{factor}} of the same length as
\code{x}, representing which interval contains each element of \code{x}.
\code{kiru()} is an alias for \code{chop}.
\code{tab()} calls \code{chop()} and returns a contingency \code{\link[=table]{table()}} from the result.
}
\details{
\code{x} may be numeric, or a \link[=DateTimeClasses]{Date or Date-Time}.
\subsection{Breaks}{

\code{breaks} may be a numeric vector or a function.

If it is a vector, \code{breaks} gives the break endpoints. Repeated values create
singleton intervals. For example \code{breaks = c(1, 3, 3, 5)} creates 3
intervals: \code{[1, 3)}, \code{{3}} and \code{(3, 5]}.

If \code{breaks} is a function it is called with the \code{x}, \code{extend}, \code{left} and
\code{close_end} arguments, and should return an object of class \code{breaks}.
Use \verb{brk_*} functions in this context, to create a variety of data-dependent
breaks.
}

\subsection{Options for breaks}{

By default, left-closed intervals are created. If \code{left} is \code{FALSE}, right-
closed intervals are created.

If \code{close_end} is \code{TRUE} the end break will be closed at both ends, ensuring
that all values \code{y} with \verb{min(x) <= y <= max(x)} are included in the default
intervals.

Overall:
\itemize{
\item If \code{left} is \code{TRUE} and \code{close_end} is \code{TRUE}, breaks will look like
\code{[x1, x2), [x2, x3) ... [x_n-1, x_n]}.
\item If \code{left} is \code{FALSE} and \code{close_end} is \code{TRUE}, breaks will look like
\code{[x1, x2], (x2, x3] ... (x_n-1, x_n]}.
\item If \code{left} is \code{TRUE} and \code{close_end} is \code{FALSE}, all breaks will look like
\code{...[x1, x2) ...}.
\item If \code{left} is \code{FALSE} and \code{close_end} is \code{FALSE}, all breaks will look like
\code{...(x1, x2] ...}.
}
}

\subsection{Extending intervals}{

If \code{extend} is \code{TRUE}, intervals will be extended to \code{[-Inf,
min(breaks))} and \code{(max(breaks), Inf]}.

If \code{extend} is \code{NULL} (the default), intervals will be extended to
\code{[min(x), min(breaks))} and \code{(max(breaks), max(x)]}, \emph{only} if
necessary -- i.e. if \code{min(x) < min(breaks)} and \code{max(x) > max(breaks)}
respectively.

Extending intervals, either by \code{extend = NULL} or \code{extend = TRUE},
\emph{always} leaves the central, non-extended intervals unchanged. In particular,
\code{close_end} applies to the central intervals, not to the extended ones.
For example, if \code{breaks = c(1, 3, 5)} and \code{close_end = TRUE}, the resulting
breaks will be

\code{[1, 3), [3, 5]}

and if \code{extend = TRUE} the result will be

\code{[-Inf, 1), [1, 3), [3, 5], (5, Inf]}
}

\subsection{Labels}{

\code{labels} may be a character vector. It should have the same length as the
number of intervals. Alternatively, use a \verb{lbl_*} function such as
\code{\link[=lbl_seq]{lbl_seq()}}.

If \code{labels} is \code{NULL}, then integer codes will be returned instead of a
factor.
}

\subsection{Miscellaneous}{

\code{NA} values in \code{x}, and values which are outside the extended endpoints,
return \code{NA}.

\code{kiru()} is a synonym for \code{chop()}. If you load \code{{tidyr}}, you can use it to
avoid confusion with \code{tidyr::chop()}.

Note that \code{chop()}, like all of R, uses binary arithmetic. Thus, numbers may
not be exactly equal to what you think they should be. There is an example
below.
}
}
\examples{
chop(1:3, 2)

chop(1:10, c(2, 5, 8))

chop(1:10, c(2, 5, 8), extend = FALSE)

chop(1:10, c(2, 5, 5, 8))

chop(1:10, c(2, 5, 8), left = FALSE)

chop(1:10, c(2, 5, 8), close_end = TRUE)

chop(1:10, brk_quantiles(c(0.25, 0.75)))

chop(1:10, c(2, 5, 8), labels = lbl_dash())

# floating point inaccuracy:
chop(0.3/3, c(0, 0.1, 0.1, 1), labels = c("< 0.1", "0.1", "> 0.1"))

tab(1:10, c(2, 5, 8))

}
\seealso{
\code{\link[base:cut]{base::cut()}}, \code{\link{non-standard-types}} for chopping objects that
aren't numbers.

Other chopping functions: 
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
