% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPWRFisher.R
\name{fitPWRFisher}
\alias{fitPWRFisher}
\title{fitPWRFisher implements an optimized dynamic programming algorithm to fit a
PWR model.}
\usage{
fitPWRFisher(X, Y, K, p = 3)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Numeric vector of length \emph{m} representing the observed
response/output \eqn{y_{1},\dots,y_{m}}.}

\item{K}{The number of regimes/segments (PWR components).}

\item{p}{Optional. The order of the polynomial regression. By default, \code{p} is
set at 3.}
}
\value{
fitPWRFisher returns an object of class \link{ModelPWR}.
}
\description{
fitPWRFisher is used to fit a Piecewise Regression (PWR) model by
maximum-likelihood via an optimized dynamic programming algorithm. The
estimation performed by the dynamic programming algorithm provides an optimal
segmentation of the time series.
}
\details{
fitPWRFisher function implements an optimized dynamic programming
algorithm of the PWR model. This function starts with the calculation of
the "cost matrix" then it estimates the transition points given \code{K} the
number of regimes thanks to the method \code{computeDynamicProgram} (method of
the class \link{ParamPWR}).
}
\examples{
data(univtoydataset)

pwr <- fitPWRFisher(univtoydataset$x, univtoydataset$y, K = 5, p = 1)

pwr$summary()

pwr$plot()
}
\seealso{
\link{ModelPWR}, \link{ParamPWR}, \link{StatPWR}
}
