% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelRHLP.R
\docType{class}
\name{ModelRHLP-class}
\alias{ModelRHLP-class}
\alias{ModelRHLP}
\title{A Reference Class which represents a fitted RHLP model.}
\description{
ModelRHLP represents an estimated RHLP model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamRHLP} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatRHLP} object. It contains all the statistics
associated to the RHLP model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("regressors", "estimatedsignal", "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"regressors" = } Polynomial regression components
        (fields \code{polynomials} and \code{pi_ik} of class
        \link{StatRHLP}).
      \item \code{"estimatedsignal" = } Estimated signal (fields
      \code{Ex} and \code{klas} of class \link{StatRHLP}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatRHLP}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the graphs mentioned above are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(univtoydataset)

rhlp <- emRHLP(univtoydataset$x, univtoydataset$y, K = 3, p = 1, verbose = TRUE)

# rhlp is a ModelMHMMR object. It contains some methods such as 'summary' and 'plot'
rhlp$summary()
rhlp$plot()

# rhlp has also two fields, stat and param which are reference classes as well

# Log-likelihood:
rhlp$stat$loglik

# Parameters of the polynomial regressions:
rhlp$param$beta
}
\seealso{
\link{ParamRHLP}, \link{StatRHLP}
}
