% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sampler_hmc}
\alias{sampler_hmc}
\title{Hamiltonian Monte-Carlo Sampler (HMC)}
\usage{
sampler_hmc(
  start,
  distr_name = NULL,
  distr_params = NULL,
  epsilon = 0.5,
  L = 10,
  iterations = 1024,
  weights = NULL,
  custom_density = NULL
)
}
\arguments{
\item{start}{Vector. Starting position of the sampler.}

\item{distr_name}{Name of the distribution from which to sample from.}

\item{distr_params}{Distribution parameters.}

\item{epsilon}{Size of the leapfrog step}

\item{L}{Number of leapfrog steps per iteration}

\item{iterations}{Number of iterations of the sampler.}

\item{weights}{If using a mixture distribution, the weights given to each constituent distribution. If none given, it defaults to equal weights for all distributions.}

\item{custom_density}{Instead of providing names, params and weights, the user may prefer to provide a custom density function.}
}
\value{
A named list containing
\enumerate{
\item{Samples: the history of visited places (an n x d matrix, n = iterations; d = dimensions)}
\item{Momentums: the history of momentum values (an n x d matrix, n = iterations; d = dimensions). Nothing is proposed in the first iteration (the first iteration is the start value) and so the first row is NA}
\item{Acceptance Ratio: The proportion of proposals that were accepted.}
}
}
\description{
Hamiltonian Monte-Carlo, also called Hybrid Monte Carlo, is a sampling algorithm that uses Hamiltonian Dynamics to approximate a posterior distribution. Unlike MH and MC3, HMC uses not only the current position, but also a sense of momentum, to draw future samples. An introduction to HMC can be read in \insertCite{betancourt2018ConceptualIntroductionHamiltonian;textual}{samplr}.
}
\details{
This implementations assumes that the momentum is drawn from a normal distribution with mean 0 and identity covariance matrix (p ~ N (0, I)). Hamiltonian Monte Carlo does not support discrete distributions.

This algorithm has been used to model human data in \insertCite{aitchison2016HamiltonianBrainEfficient;textual}{samplr}, \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplr} and \insertCite{zhu2022UnderstandingStructureCognitive;textual}{samplr} among others.
}
\examples{
result <- sampler_hmc(
    distr_name = "norm", distr_params = c(0,1), 
    start = 1, epsilon = .01, L = 100
    )
cold_chain <- result$Samples
}
\references{
\insertAllCited{}
}
