% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys.utils.R
\name{sys.intracorr}
\alias{sys.intracorr}
\title{Intraclass correlation coefficient}
\usage{
sys.intracorr(N, n, data)
}
\arguments{
\item{N}{Population size}

\item{n}{Sample size}

\item{data}{Population data}
}
\value{
Intraclass correlation
}
\description{
Intraclass correlation coefficient
}
\details{
This value serves as a comparison between systematic and simple random sampling precision.\cr
At value=1 the systematic precision is minimum. At value=0 both sampling methods precision
are equal. At value= \eqn{\frac{-1}{n-1}} systematic precision is maximum.\cr
Summarising at values between 1 and 0 simple random sampling estimation has more precision
than systematic, so method="srs" should be set at \code{\link{sys.estimator}}.
The other way method="sys" of interpenetrating samples method is better.
}
\examples{
data<-c(1,3,5,2,4,6,2,7,3)
sys.intracorr(9, 3, data)  #0.34375 example 1
}
