% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-metadata.R
\name{sf_update_metadata}
\alias{sf_update_metadata}
\title{Update Object or Field Metadata in Salesforce}
\usage{
sf_update_metadata(
  metadata_type,
  metadata,
  control = list(...),
  ...,
  all_or_none = deprecated(),
  verbose = FALSE
)
}
\arguments{
\item{metadata_type}{\code{character}; string on what type of metadata to create.}

\item{metadata}{\code{list}; metadata components to be created formatted as
XML before being sent via API.}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{all_or_none}{\code{logical}; allows a call to roll back all changes unless all
records are processed successfully.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{tbl_df} containing the creation result for each submitted metadata component
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes a list of Metadata components and sends them
to Salesforce to update an object that already exists
}
\note{
The update key is based on the fullName parameter of the metadata, so updates are triggered
when an existing Salesforce element matches the metadata type and fullName.
}
\examples{
\dontrun{
# create an object that we can update
base_obj_name <- "Custom_Account1"
custom_object <- list()
custom_object$fullName <- paste0(base_obj_name, "__c")
custom_object$label <- paste0(gsub("_", " ", base_obj_name))
custom_object$pluralLabel <- paste0(base_obj_name, "s")
custom_object$nameField <- list(displayFormat = 'AN-{0000}', 
                                label = paste0(base_obj_name, ' Number'), 
                                type = 'AutoNumber')
custom_object$deploymentStatus <- 'Deployed'
custom_object$sharingModel <- 'ReadWrite'
custom_object$enableActivities <- 'true'
custom_object$description <- paste0(base_obj_name, " created by the Metadata API")
custom_object_result <- sf_create_metadata(metadata_type = 'CustomObject',
                                           metadata = custom_object)
# now update the object that was created
update_metadata <- custom_object 
update_metadata$fullName <- 'Custom_Account1__c'
update_metadata$label <- 'New Label Custom_Account1'
update_metadata$pluralLabel <- 'Custom_Account1s_new'
updated_custom_object_result <- sf_update_metadata(metadata_type = 'CustomObject',
                                                   metadata = update_metadata)
}
}
\seealso{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}{Salesforce Documentation}
}
