% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_get_job_bulk}
\alias{sf_get_job_bulk}
\title{Get Bulk API Job}
\usage{
sf_get_job_bulk(
  job_id,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  query_operation = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{query_operation}{logical; an indicator of whether the job is a query job,
which is needed when using the Bulk 2.0 API because the URI endpoints are different
for the "ingest" vs. the "query" jobs.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{tbl_df} of parameters defining the details of the specified job id
}
\description{
This function retrieves details about a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
refreshed_job_info <- sf_get_job_bulk(job_info$id)
sf_abort_job_bulk(refreshed_job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
