% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-query.R
\name{sf_query_bulk}
\alias{sf_query_bulk}
\title{Run Bulk Query}
\usage{
sf_query_bulk(soql, object_name, api_type = c("Bulk 1.0"),
  interval_seconds = 5, max_attempts = 100, verbose = FALSE)
}
\arguments{
\item{soql}{character; a string defining a SOQL query (e.g. "SELECT Id, Name FROM Account")}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{interval_seconds}{integer; defines the seconds between attempts to check 
for job completion}

\item{max_attempts}{integer; defines then max number attempts to check for job 
completion before stopping}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} of the recordset returned by the query
}
\description{
This function is a convenience wrapper for submitting and retrieving 
bulk query API jobs
}
\examples{
\dontrun{
# select all Ids from Account object
ids <- sf_query_bulk(soql='SELECT Id FROM Account', object_name='Account')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
