% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{sf_delete}
\alias{sf_delete}
\title{Delete Records}
\usage{
sf_delete(ids, object_name, all_or_none = FALSE, api_type = c("REST",
  "SOAP", "Bulk 1.0", "Bulk 2.0"), ..., verbose = FALSE)
}
\arguments{
\item{ids}{\code{vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; if not a vector, there must be a column called Id (case-insensitive) 
that can be passed in the request}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{all_or_none}{logical; allows a call to roll back all changes unless all 
records are processed successfully}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{...}{Other arguments passed on to \code{\link{sf_bulk_operation}}.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
Deletes one or more records to your organization’s data.
}
\examples{
\dontrun{
n <- 3
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_contacts_result1 <- sf_create(new_contacts, object_name="Contact")
deleted_contacts_result1 <- sf_delete(new_contacts_result1$id, 
                                      object_name="Contact")   

new_contacts_result2 <- sf_create(new_contacts, "Contact")
deleted_contacts_result2 <- sf_delete(new_contacts_result2$id, 
                                      object_name="Contact", 
                                      api_type="Bulk")                             
}
}
