% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{sf_create}
\alias{sf_create}
\title{Create Records}
\usage{
sf_create(input_data, object_name, all_or_none = FALSE, api_type = c("SOAP",
  "REST", "Bulk 1.0", "Bulk 2.0"), ..., verbose = FALSE)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; data can be coerced into a \code{data.frame}}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{all_or_none}{logical; allows a call to roll back all changes unless all 
records are processed successfully}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{...}{Other arguments passed on to \code{\link{sf_bulk_operation}}.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
Adds one or more new records to your organization’s data.
}
\examples{
\dontrun{
n <- 3
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_contacts_result <- sf_create(new_contacts, object_name="Contact")
new_contacts_result <- sf_create(new_contacts, object_name="Contact", api_type="REST")
}
}
