% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FHme_nonsamples.R
\name{FHme_nonsamples}
\alias{FHme_nonsamples}
\title{Fay-Herriot Model with Measurement Error of Nonsampled Area}
\usage{
FHme_nonsamples(formula, var.x, vardir, type.x = "witherror", n.cluster, data)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted. The variables included  \code{formula} must have a length equal to the number of domains \code{m}. This formula can provide auxiliary variable either measured with error or without error or combination between them. If the auxiliary variable are combination between \code{noerror} and \code{witherror} variable, input all \code{witherror} variable first then \code{noerror} variable.}

\item{var.x}{vector containing mean squared error of \code{X} . The values must be sorted as the \code{X}. if you use optional \code{data}, input this parameter use \code{c("")}, example: \code{var.x = c("c1") or var.x = c("c1","c2")}.}

\item{vardir}{vector containing the \code{m} sampling variances of direct estimators for each domain. The values must be sorted as the \code{Y}.}

\item{type.x}{type of auxiliary variable used in the model. Either source measured with \code{noerror}, \code{witherror} and \code{mix}. Default value is \code{witherror}.}

\item{n.cluster}{either the number of clusters, say \code{k}, or a set of initial (distinct) cluster centers.}

\item{data}{data frame containing the variables named in formula, vardir, and var.x.}
}
\value{
The function returns a list with the following objects:
\describe{
   \item{sampled_data}{data frame of nonsampled area containing cluster information and mean of random effect for each cluster.}
   \item{nonsampled_data}{data frame of sampled area containing cluster information and mean of random effect for each cluster.}
   \item{full_data}{data frame of observed area containing cluster information and mean of random effect for each cluster.}
   \item{result_sampled}{a list containing result of small area estimation for sampled area, containing following objects: \code{eblup}, \code{fit}, and \code{ref} values of the random effect for each area.}
   \item{result_nonsampled}{a list containing result of small area estimation for nonsampled area, containing following objects: \code{eblup} and \code{estcoef}.}
   \item{mse_sample}{a list containing mean squared error of sampled area and the values of \code{g1}, referring to \code{g1} in MSE by Prasad-Rao (1990).}
   \item{mse_nonsample}{a list containing mean squared error of nonsampled area and the values of \code{g1}, referring to \code{g1} in MSE by Prasad-Rao (1990).}
   \item{cluster}{data frame containing cluster information and mean of random effect for each cluster.}
 }
}
\description{
This function gives the EBLUP estimator of nonsampled area using cluster information.
}
\details{
A formula has an implied intercept term. To remove this use either y ~ x - 1 or y ~ 0 + x. See \code{\link[stats]{formula}}  for more details of allowed formulae.
}
\examples{
\donttest{
data(nonsample)
test <- FHme_nonsamples(formula = y ~ x.hat, var.x = c("var.x"),
                        vardir = vardir, n.cluster = 3, data = nonsample)
}

}
