% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGPois.R
\docType{data}
\name{dataGPois}
\alias{dataGPois}
\title{Synthetic Dataset for SAE HB under Generalized Poisson Distribution}
\format{
A data frame with 50 rows and 4 variables:
\describe{
  \item{y}{Direct Estimation of y}
  \item{x1}{Auxiliary variable of x1}
  \item{x2}{Auxiliary variable of x2}
  \item{vardir}{Sampling Variance of y}
}
}
\usage{
dataGPois
}
\description{
Dataset to simulate Small Area Estimation using Hierarchical Bayesian Method under Generalized Poisson Distribution.

This data is generated by these following steps:

\enumerate{
  \item Generate sampling random area effect \code{u} with  \code{u ~ N(0,1)}. The auxiliary variables are generated by uniform distribution with  \code{x1 ~ U(0,1)} and  \code{x2 ~ U(0,1)}. The coefficient parameters \eqn{ \beta_{0}, \beta_{1}, and \beta_{2}}{\beta0, \beta1, \beta2} are set with a certain values. we set the parameter of dispersion, \eqn{\alpha = 0.5}.
  \cr Calculate \eqn{\mu}{\mu} = \eqn{exp(\beta_{0} + x_{1}\beta_{1} + x_{2}\beta_{2} + u)}{exp(\beta0 + x1\beta1 + x2\beta2 + u)}
  \cr Generate direct estimate \code{y ~ Generalized Poisson} with parameters:  \eqn{\mu}{\mu} and \eqn{\alpha}{\alpha}
  \cr The variance of \code{y} is obtained with \code{var(y)} = \eqn{\mu /(1 - \alpha)^2}
  \item Auxiliary variables \code{x1,x2}, direct estimation \code{(y)} and vardir are combined in a dataframe called \code{dataGPois}
}
}
\keyword{datasets}
