% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sFFLHD.R
\docType{class}
\name{sFFLHD-class}
\alias{sFFLHD}
\alias{sFFLHD-class}
\title{sFFLHD object that gives a batch of points at a time.}
\value{
A sFFLHD object
}
\description{
sFFLHD object that gives a batch of points at a time.
}
\section{Fields}{

\describe{
\item{\code{D}}{numeric. The number of dimensions for the design. Must be set.}

\item{\code{L}}{numeric. The number of points in each batch, also the number of
levels of each dimension. Must be set.}

\item{\code{maximin}}{logical. Should maximin distance be used to space out points?}

\item{\code{a}}{numeric. A root of L that determines the intermediate stages.
Is automatically set to smallest possible value, which is recommended.}

\item{\code{b}}{integer. The batch number.}

\item{\code{nb}}{integer. The number of points selected so far.}

\item{\code{lb}}{numeric. Current levels of the small grid.}

\item{\code{Lb}}{numeric. Current levels of the intermediate grid.}

\item{\code{Xb}}{matrix. Current design matrix, continuous from 0 to 1.}

\item{\code{Vb}}{matrix. Small grid design.}

\item{\code{Mb}}{matrix. Intermediate grid design.}

\item{\code{Wb}}{matrix. Big grid design.}

\item{\code{A1}}{matrix. The first OA slice.}

\item{\code{r}}{integer. Used to keep track of loop index.}

\item{\code{p}}{integer. Used to keep track of loop index.}

\item{\code{Ar}}{matrix. Current Ar.}

\item{\code{stage}}{integer. Current stage.}

\item{\code{vii}}{integer. Used to keep track of location in stage 2.}

\item{\code{Fslices}}{list. A list of slices.}

\item{\code{FF1.1}}{matrix. Temporary matrix used to generate slices.}

\item{\code{Mb.store}}{matrix. Temporary storage of Mb.}

\item{\code{v.shuffle}}{integer. A storage value for storing order.
Requires extra optimization.}
}}
\examples{
s <- sFFLHD$new(D=2,L=3)
s$get.batch()
s <- sFFLHD$new(D=2,L=4)
s$get.batch()
}

